/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.preparer;

import io.zonky.test.db.preparer.RecordingDataSource;
import io.zonky.test.db.preparer.ReplayableDatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.Equivalence;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.base.Preconditions;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableSet;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.AtomicLongMap;
import io.zonky.test.db.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class RecordingMethodInterceptor
implements MethodInterceptor {
    private static final List<Predicate<Method>> EXCLUDED_METHODS = ImmutableList.of(new MethodPredicate((Class)Object.class, new String[]{"equals", "hashCode", "toString"}), new MethodPredicate((Class)Wrapper.class, new String[]{"isWrapperFor"}), new MethodPredicate((Class)DataSource.class, new String[]{"getLogWriter", "setLogWriter", "getLoginTimeout", "getParentLogger"}), new MethodPredicate((Class)Connection.class, new String[]{"getAutoCommit", "isClosed", "getMetaData", "isReadOnly", "getCatalog", "getTransactionIsolation", "getWarnings", "clearWarnings", "getTypeMap", "getHoldability", "isValid", "getClientInfo", "getSchema", "getNetworkTimeout"}), new MethodPredicate((Class)Statement.class, new String[]{"getMaxFieldSize", "getMaxRows", "getQueryTimeout", "getWarnings", "clearWarnings", "getResultSet", "getUpdateCount", "getMoreResults", "getFetchDirection", "getFetchSize", "getResultSetConcurrency", "getResultSetType", "getMoreResults", "getGeneratedKeys", "getResultSetHoldability", "isClosed", "isPoolable", "isCloseOnCompletion", "getLargeUpdateCount", "getLargeMaxRows"}), new MethodPredicate((Class)PreparedStatement.class, new String[]{"getMetaData", "getParameterMetaData"}), new MethodPredicate((Class)CallableStatement.class, new String[]{"getString", "getBoolean", "getByte", "getShort", "getInt", "getLong", "getFloat", "getDouble", "getBigDecimal", "getBytes", "getDate", "getTime", "getTimestamp", "getObject", "getRef", "getBlob", "getClob", "getArray", "getURL", "getRowId", "getNClob", "getSQLXML", "getNString", "getNCharacterStream", "getCharacterStream"}), new MethodPredicate((Class)ResultSet.class, new String[]{"wasNull", "getString", "getBoolean", "getByte", "getShort", "getInt", "getLong", "getFloat", "getDouble", "getBigDecimal", "getBytes", "getDate", "getTime", "getTimestamp", "getAsciiStream", "getUnicodeStream", "getBinaryStream", "getWarnings", "clearWarnings", "getCursorName", "getMetaData", "getObject", "findColumn", "getCharacterStream", "isBeforeFirst", "isAfterLast", "isFirst", "isLast", "getRow", "getFetchDirection", "getFetchSize", "getType", "getConcurrency", "rowUpdated", "rowInserted", "rowDeleted", "getRef", "getBlob", "getClob", "getArray", "getURL", "getRowId", "getHoldability", "isClosed", "getNClob", "getSQLXML", "getNString", "getNCharacterStream"}));
    private static final String ROOT_REFERENCE = "dataSource";
    private final String thisId;
    private final RecordingContext context;

    public RecordingMethodInterceptor() {
        this.thisId = ROOT_REFERENCE;
        this.context = new RecordingContext();
    }

    private RecordingMethodInterceptor(String thisId, RecordingContext context) {
        this.thisId = thisId;
        this.context = context;
    }

    private Object[] captureArguments(Object[] arguments) throws IOException {
        Object[] captured = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                captured[i] = new NullArgumentProvider();
            } else {
                if (arguments[i] instanceof OutputStream) {
                    throw new UnsupportedOperationException("Output streams can not be captured");
                }
                captured[i] = this.context.containsArgumentMapping(arguments[i]) ? new ArgumentReference(this.context.getArgumentId(arguments[i])) : (arguments[i] instanceof InputStream ? new InputStreamArgumentProvider((InputStream)arguments[i]) : (arguments[i] instanceof Reader ? new ReaderArgumentProvider((Reader)arguments[i]) : RecordingMethodInterceptor.captureArgument(arguments[i])));
            }
            if (!(captured[i] instanceof ArgumentProvider)) continue;
            arguments[i] = ((ArgumentProvider)captured[i]).getArgument();
        }
        return captured;
    }

    private static Object captureArgument(Object argument) {
        if (argument instanceof Date) {
            return ((Date)argument).clone();
        }
        if (argument instanceof Calendar) {
            return ((Calendar)argument).clone();
        }
        if (argument instanceof Properties) {
            return ((Properties)argument).clone();
        }
        if (argument instanceof Map) {
            return ((Map)argument).entrySet().stream().collect(Collectors.toMap(e -> RecordingMethodInterceptor.captureArgument(e.getKey()), e -> RecordingMethodInterceptor.captureArgument(e.getValue())));
        }
        if (argument instanceof Set) {
            return ((Set)argument).stream().map(RecordingMethodInterceptor::captureArgument).collect(Collectors.toSet());
        }
        if (argument instanceof List) {
            return ((List)argument).stream().map(RecordingMethodInterceptor::captureArgument).collect(Collectors.toList());
        }
        if (argument.getClass().isArray()) {
            int length = Array.getLength(argument);
            Object array = Array.newInstance(argument.getClass().getComponentType(), length);
            System.arraycopy(argument, 0, array, 0, length);
            if (!argument.getClass().getComponentType().isPrimitive()) {
                Object[] objects = (Object[])array;
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = RecordingMethodInterceptor.captureArgument(objects[i]);
                }
            }
            return array;
        }
        return argument;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Object[] arguments = this.captureArguments(invocation.getArguments());
        if (method.getDeclaringClass() == RecordingDataSource.class && methodName.equals("getPreparer")) {
            return new ReplayableDatabasePreparerImpl(this.context.recordData);
        }
        Object result = invocation.proceed();
        if (RecordingMethodInterceptor.isExcludedMethod(method)) {
            return result;
        }
        if (!(result == null || BeanUtils.isSimpleValueType(returnType) || returnType.isArray() || !returnType.isInterface() && Modifier.isFinal(result.getClass().getModifiers()))) {
            String returnId = this.context.generateIdentifier(returnType);
            this.context.addRecord(new Record(this.thisId, methodName, arguments, returnId));
            Object proxiedResult = this.createRecordingProxy(returnId, returnType, result);
            this.context.registerArgumentMapping(returnId, proxiedResult);
            return proxiedResult;
        }
        this.context.addRecord(new Record(this.thisId, methodName, arguments, null));
        return result;
    }

    private Object createRecordingProxy(String identifier, Class<?> returnType, Object result) {
        ProxyFactory proxyFactory = new ProxyFactory(result);
        proxyFactory.addAdvice((Advice)new RecordingMethodInterceptor(identifier, this.context));
        if (returnType.isInterface()) {
            proxyFactory.addInterface(returnType);
        } else {
            proxyFactory.setProxyTargetClass(true);
        }
        return proxyFactory.getProxy();
    }

    private static boolean isExcludedMethod(Method method) {
        for (Predicate<Method> exclusionPredicate : EXCLUDED_METHODS) {
            if (!exclusionPredicate.test(method)) continue;
            return true;
        }
        return false;
    }

    private static class ReaderArgumentProvider
    implements ArgumentProvider {
        private final char[] data;

        public ReaderArgumentProvider(Reader reader) throws IOException {
            CharArrayWriter writer = new CharArrayWriter();
            FileCopyUtils.copy((Reader)reader, (Writer)writer);
            this.data = writer.toCharArray();
        }

        @Override
        public Object getArgument() {
            return new CharArrayReader(this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReaderArgumentProvider that = (ReaderArgumentProvider)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private static class InputStreamArgumentProvider
    implements ArgumentProvider {
        private final byte[] data;

        public InputStreamArgumentProvider(InputStream stream) throws IOException {
            this.data = FileCopyUtils.copyToByteArray((InputStream)stream);
        }

        @Override
        public Object getArgument() {
            return new ByteArrayInputStream(this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputStreamArgumentProvider that = (InputStreamArgumentProvider)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private static class NullArgumentProvider
    implements ArgumentProvider {
        private NullArgumentProvider() {
        }

        @Override
        public Object getArgument() {
            return null;
        }

        public String toString() {
            return "null";
        }
    }

    private static class ArgumentReference {
        private final String referenceId;

        private ArgumentReference(String referenceId) {
            this.referenceId = referenceId;
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentReference that = (ArgumentReference)o;
            return Objects.equals(this.referenceId, that.referenceId);
        }

        public int hashCode() {
            return Objects.hash(this.referenceId);
        }
    }

    private static interface ArgumentProvider {
        public Object getArgument();
    }

    private static class Record {
        private final String thisId;
        private final String methodName;
        private final List<Object> arguments;
        private final String resultId;

        private Record(String thisId, String methodName, Object[] arguments, String resultId) {
            this.thisId = thisId;
            this.methodName = methodName;
            this.arguments = ImmutableList.copyOf(arguments);
            this.resultId = resultId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return Objects.equals(this.thisId, record.thisId) && Objects.equals(this.methodName, record.methodName) && Objects.equals(this.arguments, record.arguments) && Objects.equals(this.resultId, record.resultId);
        }

        public int hashCode() {
            return Objects.hash(this.thisId, this.methodName, this.arguments, this.resultId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("thisId", this.thisId).add("methodName", this.methodName).add("arguments", this.arguments).add("resultId", this.resultId).toString();
        }
    }

    public static class ReplayableDatabasePreparerImpl
    implements ReplayableDatabasePreparer {
        private static final Logger logger = LoggerFactory.getLogger(ReplayableDatabasePreparer.class);
        private final List<Record> recordData;

        private ReplayableDatabasePreparerImpl(Collection<Record> recordData) {
            LinkedList<Record> records = new LinkedList<Record>(recordData);
            List<Record> removableRecords = records.stream().filter(ReplayableDatabasePreparerImpl::isGetConnectionMethod).filter(method -> !ReplayableDatabasePreparerImpl.hasUsefulCommands(records, ((Record)method).resultId) || !ReplayableDatabasePreparerImpl.hasCloseMethod(records, ((Record)method).resultId)).collect(Collectors.toList());
            removableRecords.forEach(method -> ReplayableDatabasePreparerImpl.removeAllReferences(records, method));
            this.recordData = ImmutableList.copyOf(records);
        }

        @Override
        public boolean hasRecords() {
            return !this.recordData.isEmpty();
        }

        @Override
        public long estimatedDuration() {
            long recordsCount = this.recordData.stream().filter(record -> !((Record)record).methodName.equals("next")).count();
            return recordsCount / 2L;
        }

        @Override
        public void prepare(DataSource dataSource) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            HashMap<String, DataSource> context = new HashMap<String, DataSource>();
            context.put(RecordingMethodInterceptor.ROOT_REFERENCE, dataSource);
            for (Record record : this.recordData) {
                Object target = context.get(record.thisId);
                Object[] arguments = record.arguments.stream().map(arg -> ReplayableDatabasePreparerImpl.mapArgument(arg, context)).toArray();
                Object result = ReflectionUtils.invokeMethod(target, record.methodName, arguments);
                if (record.resultId == null) continue;
                Preconditions.checkState(result != null, "The result does not match the recorded data");
                context.put(record.resultId, (DataSource)result);
            }
            logger.trace("Database has been successfully prepared in {}", (Object)stopwatch);
        }

        private static Object mapArgument(Object argument, Map<String, Object> context) {
            if (argument instanceof ArgumentReference) {
                return context.get(((ArgumentReference)argument).getReferenceId());
            }
            if (argument instanceof ArgumentProvider) {
                return ((ArgumentProvider)argument).getArgument();
            }
            return argument;
        }

        private static boolean isGetConnectionMethod(Record record) {
            return record.thisId.equals(RecordingMethodInterceptor.ROOT_REFERENCE) && record.methodName.equals("getConnection") && record.arguments.isEmpty();
        }

        private static boolean hasUsefulCommands(List<Record> records, String connectionId) {
            return records.stream().anyMatch(record -> ((Record)record).thisId.equals(connectionId) && (!((Record)record).methodName.equals("close") || !((Record)record).arguments.isEmpty()));
        }

        private static boolean hasCloseMethod(List<Record> records, String connectionId) {
            return records.stream().anyMatch(record -> ((Record)record).thisId.equals(connectionId) && ((Record)record).methodName.equals("close") && ((Record)record).arguments.isEmpty());
        }

        private static void removeAllReferences(List<Record> records, Record record) {
            records.removeIf(r -> r.equals(record));
            Set<Record> removableRecords = records.stream().filter(r -> ((Record)r).thisId.equals(record.resultId)).collect(Collectors.toSet());
            removableRecords.forEach(r -> ReplayableDatabasePreparerImpl.removeAllReferences(records, r));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplayableDatabasePreparerImpl that = (ReplayableDatabasePreparerImpl)o;
            return Objects.equals(this.recordData, that.recordData);
        }

        public int hashCode() {
            return Objects.hash(this.recordData);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("recordDataSize", this.recordData.size()).add("estimatedDuration", this.estimatedDuration()).toString();
        }
    }

    private static class RecordingContext {
        private final AtomicLongMap<String> sequences = AtomicLongMap.create();
        private final BlockingQueue<Record> recordData = new LinkedBlockingQueue<Record>();
        private final ConcurrentMap<Equivalence.Wrapper<Object>, String> argumentMapping = new ConcurrentHashMap<Equivalence.Wrapper<Object>, String>();

        public String generateIdentifier(Class<?> type) {
            String typeName = StringUtils.uncapitalize((String)type.getSimpleName());
            long paramIndex = this.sequences.incrementAndGet(typeName);
            return typeName + paramIndex;
        }

        public void addRecord(Record record) {
            this.recordData.add(record);
        }

        public void registerArgumentMapping(String argumentId, Object argumentValue) {
            this.argumentMapping.put(RecordingContext.identity(argumentValue), argumentId);
        }

        public boolean containsArgumentMapping(Object argumentValue) {
            return this.argumentMapping.containsKey(RecordingContext.identity(argumentValue));
        }

        public String getArgumentId(Object argumentValue) {
            return (String)this.argumentMapping.get(RecordingContext.identity(argumentValue));
        }

        private static <T> Equivalence.Wrapper<T> identity(T reference) {
            return Equivalence.identity().wrap(reference);
        }
    }

    private static class MethodPredicate
    implements Predicate<Method> {
        private final Class<?> declaringClass;
        private final Set<String> methodNames;

        private MethodPredicate(Class<?> declaringClass, String ... methodNames) {
            this.declaringClass = declaringClass;
            this.methodNames = ImmutableSet.copyOf(methodNames);
        }

        @Override
        public boolean test(Method method) {
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            if (this.declaringClass.isAssignableFrom(declaringClass)) {
                return this.methodNames.contains(methodName);
            }
            return false;
        }
    }
}

