/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.preparer;

import io.zonky.test.db.preparer.RecordingMethodInterceptor;
import io.zonky.test.db.preparer.ReplayableDatabasePreparer;
import java.lang.reflect.Modifier;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;

public interface RecordingDataSource
extends DataSource {
    public ReplayableDatabasePreparer getPreparer();

    public static RecordingDataSource wrap(DataSource dataSource) {
        ProxyFactory proxyFactory = new ProxyFactory((Object)dataSource);
        proxyFactory.addAdvice((Advice)new RecordingMethodInterceptor());
        proxyFactory.addInterface(RecordingDataSource.class);
        if (!Modifier.isFinal(dataSource.getClass().getModifiers())) {
            proxyFactory.setProxyTargetClass(true);
        }
        return (RecordingDataSource)proxyFactory.getProxy();
    }
}

