/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.h2;

import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.h2.H2EmbeddedDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.h2.Driver;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public class H2DatabaseProvider
implements DatabaseProvider {
    private static final Logger logger = LoggerFactory.getLogger(H2DatabaseProvider.class);
    private static final Server server = H2DatabaseProvider.startServer();

    private static Server startServer() {
        try {
            Server server = Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers", "-tcpPort", "0"}).start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Server)server).shutdown()));
            return server;
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        SimpleDriverDataSource dataSource = new SimpleDriverDataSource();
        String databaseName = UUID.randomUUID().toString();
        dataSource.setDriverClass(Driver.class);
        dataSource.setUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", databaseName));
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        H2EmbeddedDatabase database = new H2EmbeddedDatabase(server, (DataSource)dataSource, databaseName, () -> H2DatabaseProvider.shutdownDatabase((DataSource)dataSource, databaseName));
        try {
            if (preparer != null) {
                preparer.prepare(database);
            }
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
        return database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(H2DatabaseProvider.class);
    }

    private static void shutdownDatabase(DataSource dataSource, String dbName) {
        CompletableFuture.runAsync(() -> {
            try {
                H2DatabaseProvider.executeStatement(dataSource, "SHUTDOWN");
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.warn("Unable to release '{}' database", (Object)dbName, (Object)e);
                }
                logger.warn("Unable to release '{}' database", (Object)dbName);
            }
        });
    }

    private static void executeStatement(DataSource dataSource, String ddlStatement) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute(ddlStatement);
        }
    }
}

