/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway.preparer;

import io.zonky.test.db.flyway.FlywayDescriptor;
import io.zonky.test.db.flyway.FlywayWrapper;
import io.zonky.test.db.flyway.preparer.FlywayDatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;

public class MigrateFlywayDatabasePreparer
extends FlywayDatabasePreparer {
    private volatile Long estimatedDuration;

    public MigrateFlywayDatabasePreparer(FlywayDescriptor descriptor) {
        super(descriptor);
    }

    public MigrateFlywayDatabasePreparer(FlywayDescriptor descriptor, long estimatedDuration) {
        super(descriptor);
        this.estimatedDuration = estimatedDuration;
    }

    @Override
    public long estimatedDuration() {
        if (this.estimatedDuration == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            long migrationsCount = this.descriptor.getLocations().stream().map(location -> location.replaceFirst("^filesystem:", "file:")).mapToLong(location -> this.resolveMigrations(resolver, (String)location)).sum();
            this.estimatedDuration = 25L + 25L * migrationsCount;
            this.logger.trace("Resolved {} migrations in {}", (Object)migrationsCount, (Object)stopwatch);
        }
        return this.estimatedDuration;
    }

    @Override
    protected Object doOperation(FlywayWrapper wrapper) {
        return wrapper.migrate();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("schemas", this.descriptor.getSchemas()).add("locations", this.descriptor.getLocations()).add("estimatedDuration", this.estimatedDuration()).toString();
    }

    protected long resolveMigrations(PathMatchingResourcePatternResolver resolver, String location) {
        String[] migrationPrefixes = new String[]{this.descriptor.getSqlMigrationPrefix(), this.descriptor.getRepeatableSqlMigrationPrefix()};
        String[] migrationSuffixes = this.descriptor.getSqlMigrationSuffixes().toArray(new String[0]);
        try {
            return Stream.of(resolver.getResources(location + "/**/*")).map(Resource::getFilename).filter(Objects::nonNull).filter(filename -> {
                boolean isSqlMigration = StringUtils.startsWithAny((String)filename, (String[])migrationPrefixes) && StringUtils.endsWithAny((String)filename, (String[])migrationSuffixes);
                return isSqlMigration || StringUtils.endsWith((String)filename, (String)".class");
            }).count();
        }
        catch (Exception e) {
            this.logger.warn("Unexpected error when resolving flyway locations", (Throwable)e);
            return 200L;
        }
    }
}

