/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway;

import io.zonky.test.db.flyway.FlywayDatabaseExtension;
import io.zonky.test.db.flyway.FlywayWrapper;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableCollection;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.flywaydb.core.Flyway;
import org.flywaydb.test.annotation.FlywayTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class OptimizedFlywayTestExecutionListener
implements TestExecutionListener,
Ordered {
    private static final TestExecutionListener listener = OptimizedFlywayTestExecutionListener.initListener();
    private static final Logger flywayLogger = LoggerFactory.getLogger((String)"org.flywaydb.test.FlywayTestExecutionListener");

    public int getOrder() {
        return 3900;
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        listener.beforeTestClass(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        listener.prepareTestInstance(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        listener.beforeTestMethod(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void beforeTestExecution(TestContext testContext) throws Exception {
        listener.beforeTestExecution(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void afterTestExecution(TestContext testContext) throws Exception {
        listener.afterTestExecution(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        listener.afterTestMethod(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        listener.afterTestClass(testContext);
        OptimizedFlywayTestExecutionListener.processPendingFlywayOperations(testContext);
    }

    private static void processPendingFlywayOperations(TestContext testContext) {
        if (listener instanceof NoOpTestExecutionListener) {
            return;
        }
        ApplicationContext applicationContext = testContext.getApplicationContext();
        if (applicationContext.getBeanNamesForType(FlywayDatabaseExtension.class, false, false).length > 0) {
            FlywayDatabaseExtension flywayDatabaseExtension = (FlywayDatabaseExtension)applicationContext.getBean(FlywayDatabaseExtension.class);
            flywayDatabaseExtension.processPendingOperations();
        }
    }

    private static TestExecutionListener initListener() {
        try {
            if (ClassUtils.isPresent((String)"org.flywaydb.core.Flyway", null)) {
                if (ClassUtils.isPresent((String)"org.flywaydb.test.FlywayTestExecutionListener", null)) {
                    Class listener = ClassUtils.forName((String)"org.flywaydb.test.FlywayTestExecutionListener", null);
                    Method listenerMethod = ReflectionUtils.findMethod((Class)listener, (String)"locationsMigrationHandling", (Class[])new Class[]{FlywayTest.class, Flyway.class, String.class});
                    if (listenerMethod != null) {
                        Class<?> modifiedListener = OptimizedFlywayTestExecutionListener.replaceMethod(listenerMethod, x$0 -> new LocationsMigrationHandlingMethodReplacer((MethodVisitor)x$0));
                        return (TestExecutionListener)io.zonky.test.db.util.ReflectionUtils.invokeConstructor(modifiedListener, new Object[0]);
                    }
                    throw new IllegalStateException("org.flywaydb.test.FlywayTestExecutionListener#locationsMigrationHandling method not found");
                }
                if (ClassUtils.isPresent((String)"org.flywaydb.test.junit.FlywayTestExecutionListener", null)) {
                    return (TestExecutionListener)io.zonky.test.db.util.ReflectionUtils.invokeConstructor("org.flywaydb.test.junit.FlywayTestExecutionListener", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new NoOpTestExecutionListener();
    }

    private static Class<?> replaceMethod(Method method, Function<MethodVisitor, MethodVisitor> methodReplacer) throws IOException {
        Class<?> declaringClass = method.getDeclaringClass();
        ClassReader cr = new ClassReader(declaringClass.getResourceAsStream(declaringClass.getSimpleName() + ".class"));
        ClassWriter cw = new ClassWriter(cr, 0);
        cr.accept((ClassVisitor)new ClassTransformer(cw, method, methodReplacer), 0);
        final byte[] code = cw.toByteArray();
        return new ClassLoader(){

            Class<?> get() {
                return this.defineClass(null, code, 0, code.length);
            }
        }.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizedLocationsMigrationHandling(FlywayTest annotation, Flyway flyway, String executionInfo) {
        String[] locations = annotation.locationsForMigrate();
        FlywayWrapper wrapper = FlywayWrapper.forBean(flyway);
        List<String> oldLocations = wrapper.getLocations();
        boolean override = annotation.overrideLocations();
        try {
            ImmutableCollection useLocations = override ? ImmutableList.copyOf(locations) : ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(oldLocations)).addAll(Arrays.asList(locations))).build();
            if (flywayLogger.isDebugEnabled()) {
                flywayLogger.debug(String.format("******** Start migration from locations directories '%s'  for  '%s'.", useLocations, executionInfo));
            }
            wrapper.setLocations((List<String>)((Object)useLocations));
            wrapper.migrate();
        }
        finally {
            wrapper.setLocations(oldLocations);
        }
    }

    private static class LocationsMigrationHandlingMethodReplacer
    extends MethodVisitor {
        private final MethodVisitor writer;

        private LocationsMigrationHandlingMethodReplacer(MethodVisitor writer) {
            super(393216);
            this.writer = writer;
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.writer.visitMaxs(3, 4);
        }

        public void visitCode() {
            this.writer.visitCode();
            this.writer.visitVarInsn(25, 1);
            this.writer.visitVarInsn(25, 2);
            this.writer.visitVarInsn(25, 3);
            this.writer.visitMethodInsn(184, "io/zonky/test/db/flyway/OptimizedFlywayTestExecutionListener", "optimizedLocationsMigrationHandling", "(Lorg/flywaydb/test/annotation/FlywayTest;Lorg/flywaydb/core/Flyway;Ljava/lang/String;)V", false);
            this.writer.visitInsn(177);
        }

        public void visitEnd() {
            this.writer.visitEnd();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.writer.visitAnnotation(desc, visible);
        }

        public void visitParameter(String name, int access) {
            this.writer.visitParameter(name, access);
        }
    }

    private static class ClassTransformer
    extends ClassVisitor {
        private final String methodName;
        private final String methodDescriptor;
        private final Function<MethodVisitor, MethodVisitor> methodReplacer;

        private ClassTransformer(ClassWriter cw, Method method, Function<MethodVisitor, MethodVisitor> methodReplacer) {
            super(393216, (ClassVisitor)cw);
            this.methodName = method.getName();
            this.methodDescriptor = Type.getMethodDescriptor((Method)method);
            this.methodReplacer = methodReplacer;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!name.equals(this.methodName) || !desc.equals(this.methodDescriptor)) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            return this.methodReplacer.apply(super.visitMethod(access, name, desc, signature, exceptions));
        }
    }

    private static class NoOpTestExecutionListener
    extends AbstractTestExecutionListener {
        private NoOpTestExecutionListener() {
        }
    }
}

