/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.context;

import io.zonky.test.db.context.DatabaseContext;
import io.zonky.test.db.event.TestExecutionFinishedEvent;
import io.zonky.test.db.event.TestExecutionStartedEvent;
import io.zonky.test.db.logging.EmbeddedDatabaseReporter;
import io.zonky.test.db.preparer.CompositeDatabasePreparer;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.preparer.RecordingDataSource;
import io.zonky.test.db.preparer.ReplayableDatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.shaded.com.google.common.base.Preconditions;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableCollection;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableList;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.Futures;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.util.concurrent.SettableListenableFuture;

public class DefaultDatabaseContext
implements DatabaseContext,
BeanNameAware,
BeanFactoryAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDatabaseContext.class);
    protected final DatabaseProvider databaseProvider;
    protected final List<DatabasePreparer> corePreparers = new LinkedList<DatabasePreparer>();
    protected final List<DatabasePreparer> testPreparers = new LinkedList<DatabasePreparer>();
    protected String beanName;
    protected Thread mainThread;
    protected AsyncTaskExecutor bootstrapExecutor;
    protected ExecutionPhase executionPhase = ExecutionPhase.INITIALIZING;
    protected DatabaseState databaseState = DatabaseState.RESET;
    protected Future<EmbeddedDatabase> database;

    public DefaultDatabaseContext(ObjectFactory<DatabaseProvider> databaseProviderFactory) {
        this.databaseProvider = (DatabaseProvider)databaseProviderFactory.getObject();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.bootstrapExecutor = this.determineBootstrapExecutor(beanFactory);
    }

    @Override
    public synchronized List<DatabasePreparer> getCorePreparers() {
        return ImmutableList.copyOf(this.corePreparers);
    }

    @Override
    public synchronized List<DatabasePreparer> getTestPreparers() {
        return ImmutableList.copyOf(this.testPreparers);
    }

    @Override
    public synchronized EmbeddedDatabase getDatabase() {
        if (this.databaseState == DatabaseState.RESET && !this.isRefreshAllowed()) {
            return this.awaitDatabase();
        }
        if (this.databaseState == DatabaseState.RESET) {
            this.refreshDatabase();
        }
        if (this.executionPhase != ExecutionPhase.INITIALIZING && this.databaseState != DatabaseState.DIRTY) {
            this.databaseState = DatabaseState.DIRTY;
        }
        if (this.executionPhase != ExecutionPhase.INITIALIZING || this.databaseState == DatabaseState.RECORDING) {
            return this.awaitDatabase();
        }
        this.database = this.databaseFuture(RecordingDataSource.wrap(this.awaitDatabase()));
        logger.trace("Starting database recording - context={}", (Object)this.beanName);
        this.databaseState = DatabaseState.RECORDING;
        return this.awaitDatabase();
    }

    private boolean isRefreshAllowed() {
        if (this.mainThread != null && Thread.currentThread().getName().equals("main") && Thread.currentThread() != this.mainThread) {
            logger.warn("Threads are different - initThread={}@{}, currentThread={}@{}", new Object[]{this.mainThread, this.mainThread.hashCode(), Thread.currentThread(), Thread.currentThread().hashCode()});
        }
        return this.database == null || this.executionPhase == ExecutionPhase.INITIALIZING || this.executionPhase == ExecutionPhase.TEST_EXECUTION || Thread.currentThread() == this.mainThread;
    }

    @Override
    public DatabaseContext.ContextState getState() {
        if (this.executionPhase == ExecutionPhase.INITIALIZING) {
            return DatabaseContext.ContextState.INITIALIZING;
        }
        if (this.databaseState == DatabaseState.DIRTY) {
            return DatabaseContext.ContextState.DIRTY;
        }
        if (!this.testPreparers.isEmpty()) {
            return DatabaseContext.ContextState.AHEAD;
        }
        return DatabaseContext.ContextState.FRESH;
    }

    @EventListener
    public synchronized void handleContextRefreshed(ContextRefreshedEvent event) {
        if (event.getApplicationContext().containsBean(this.beanName) && this.mainThread == null) {
            this.stopRecording();
            this.mainThread = Thread.currentThread();
            this.executionPhase = ExecutionPhase.TEST_PREPARATION;
            logger.trace("Execution phase has been changed to {} - context={}", (Object)this.executionPhase, (Object)this.beanName);
        }
    }

    @EventListener
    public synchronized void handleTestStarted(TestExecutionStartedEvent event) {
        this.executionPhase = ExecutionPhase.TEST_EXECUTION;
        if (this.databaseState == DatabaseState.RESET) {
            this.refreshDatabase();
        }
        String databaseBeanName = this.beanName.substring(0, this.beanName.length() - "Context".length());
        EmbeddedDatabaseReporter.reportDataSource(databaseBeanName, this.awaitDatabase(), event.getTestMethod());
        logger.trace("Execution phase has been changed to {} - context={}", (Object)this.executionPhase, (Object)this.beanName);
    }

    @EventListener
    public synchronized void handleTestFinished(TestExecutionFinishedEvent event) {
        this.executionPhase = ExecutionPhase.TEST_PREPARATION;
        logger.trace("Execution phase has been changed to {} - context={}", (Object)this.executionPhase, (Object)this.beanName);
    }

    @Override
    public synchronized void reset() {
        Preconditions.checkState(this.getState() != DatabaseContext.ContextState.INITIALIZING, "Data source context must be initialized");
        Preconditions.checkState(!TestTransaction.isActive(), "Cannot reset the data source context without ending the existing transaction first");
        if (this.getState() != DatabaseContext.ContextState.FRESH) {
            this.testPreparers.clear();
            this.resetDatabase();
        }
    }

    @Override
    public synchronized void apply(DatabasePreparer preparer) {
        Preconditions.checkNotNull(preparer, "Preparer must not be null");
        this.stopRecording();
        if (this.getState() == DatabaseContext.ContextState.INITIALIZING) {
            this.corePreparers.add(preparer);
            this.refreshDatabase();
        } else if (this.getState() != DatabaseContext.ContextState.DIRTY) {
            this.testPreparers.add(preparer);
            this.resetDatabase();
        } else {
            try {
                preparer.prepare(this.awaitDatabase());
            }
            catch (SQLException e) {
                throw new IllegalStateException("Unknown error when applying the preparer", e);
            }
        }
    }

    public synchronized void destroy() {
        logger.trace("Closing database context bean - context={}", (Object)this.beanName);
        if (this.database != null) {
            try {
                this.awaitDatabase().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private synchronized void stopRecording() {
        if (this.databaseState == DatabaseState.RECORDING) {
            logger.trace("Stopping database recording - context={}", (Object)this.beanName);
            RecordingDataSource recordingDataSource = (RecordingDataSource)((Object)this.awaitDatabase());
            ReplayableDatabasePreparer recordedPreparer = recordingDataSource.getPreparer();
            if (recordedPreparer.hasRecords()) {
                this.corePreparers.add(recordedPreparer);
            }
            this.database = this.databaseFuture(AopProxyUtils.getSingletonTarget((Object)this.awaitDatabase()));
            this.databaseState = DatabaseState.FRESH;
        }
    }

    private synchronized void refreshDatabase() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.trace("Refreshing database context - context={}", (Object)this.beanName);
        if (this.database != null) {
            logger.trace("Closing previous database - context={}", (Object)this.beanName);
            this.awaitDatabase().close();
        }
        logger.trace("Creating a new database - context={}, corePreparers={}, testPreparers={}", new Object[]{this.beanName, this.corePreparers, this.testPreparers});
        ImmutableCollection preparers = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.corePreparers)).addAll(this.testPreparers)).build();
        if (this.executionPhase == ExecutionPhase.INITIALIZING) {
            this.database = this.bootstrapExecutor.submit(() -> this.lambda$refreshDatabase$0((List)((Object)preparers), stopwatch));
        } else {
            this.database = this.databaseFuture(this.databaseProvider.createDatabase(new CompositeDatabasePreparer((List<DatabasePreparer>)((Object)preparers))));
            logger.trace("Database context has been successfully refreshed in {} - context={}", (Object)stopwatch, (Object)this.beanName);
        }
        this.databaseState = DatabaseState.FRESH;
    }

    private synchronized void resetDatabase() {
        this.databaseState = DatabaseState.RESET;
    }

    private EmbeddedDatabase awaitDatabase() {
        return Futures.getUnchecked(this.database);
    }

    private Future<EmbeddedDatabase> databaseFuture(Object database) {
        SettableListenableFuture future = new SettableListenableFuture();
        future.set((Object)((EmbeddedDatabase)database));
        return future;
    }

    private AsyncTaskExecutor determineBootstrapExecutor(BeanFactory beanFactory) {
        Executor executor;
        try {
            executor = (Executor)beanFactory.getBean(TaskExecutor.class);
        }
        catch (NoSuchBeanDefinitionException ex1) {
            try {
                executor = (Executor)beanFactory.getBean("applicationTaskExecutor", Executor.class);
            }
            catch (NoSuchBeanDefinitionException ex2) {
                try {
                    executor = (Executor)beanFactory.getBean("taskExecutor", Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex3) {
                    executor = new SimpleAsyncTaskExecutor();
                }
            }
        }
        return executor instanceof AsyncTaskExecutor ? (AsyncTaskExecutor)executor : new TaskExecutorAdapter(executor);
    }

    private /* synthetic */ EmbeddedDatabase lambda$refreshDatabase$0(List preparers, Stopwatch stopwatch) throws Exception {
        EmbeddedDatabase database = this.databaseProvider.createDatabase(new CompositeDatabasePreparer(preparers));
        logger.trace("Database context has been successfully refreshed in {} - context={}", (Object)stopwatch, (Object)this.beanName);
        return database;
    }

    protected static enum DatabaseState {
        FRESH,
        DIRTY,
        RECORDING,
        RESET;

    }

    protected static enum ExecutionPhase {
        INITIALIZING,
        TEST_PREPARATION,
        TEST_EXECUTION;

    }
}

