/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider;

import com.google.common.base.MoreObjects;
import io.zonky.test.db.provider.DatabaseType;
import io.zonky.test.db.provider.ProviderType;
import java.util.Objects;
import org.springframework.util.Assert;

public final class DatabaseDescriptor {
    private final DatabaseType databaseType;
    private final ProviderType providerType;

    public DatabaseDescriptor(DatabaseType databaseType, ProviderType providerType) {
        Assert.notNull((Object)databaseType, (String)"Database type must not be null");
        Assert.notNull((Object)providerType, (String)"Provider type must not be null");
        this.databaseType = databaseType;
        this.providerType = providerType;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ProviderType getProviderType() {
        return this.providerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseDescriptor that = (DatabaseDescriptor)o;
        return Objects.equals(this.databaseType, that.databaseType) && Objects.equals(this.providerType, that.providerType);
    }

    public int hashCode() {
        return Objects.hash(this.databaseType, this.providerType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseType", (Object)this.databaseType).add("providerType", (Object)this.providerType).toString();
    }
}

