/*
 * Decompiled with CFR 0.152.
 */
package io.zla.reactions;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.Log;
import android.view.View;
import io.zla.reactions.ReactionsConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/zla/reactions/RoundedView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "config", "Lio/zla/reactions/ReactionsConfig;", "(Landroid/content/Context;Lio/zla/reactions/ReactionsConfig;)V", "cornerSize", "", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "rect", "Landroid/graphics/RectF;", "tag", "", "kotlin.jvm.PlatformType", "vHeight", "", "vWidth", "xStart", "yStart", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "android-reactions_release"})
@SuppressLint(value={"ViewConstructor"})
public final class RoundedView
extends View {
    private final String tag;
    private final Paint paint;
    private int vWidth;
    private int vHeight;
    private float cornerSize;
    private float xStart;
    private float yStart;
    private final Path path;
    private final RectF rect;
    private final ReactionsConfig config;

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        Log.d((String)this.tag, (String)("onSizeChanged: w = " + w + "; h = " + h + "; oldW = " + oldW + "; oldH = " + oldH));
        this.vWidth = w;
        this.vHeight = h;
        float xPad = this.getPaddingLeft() + this.getPaddingRight() <= 0 ? (float)this.config.getHorizontalMargin() * 2.0f : (float)(this.getPaddingLeft() + this.getPaddingRight()) / 2.0f;
        float bPad = xPad / (float)2;
        int nIcons = this.config.getReactions().size();
        float regIconSize = ((float)this.vWidth - ((float)2 * xPad + (float)(nIcons - 1) * bPad)) / (float)nIcons;
        this.xStart = this.cornerSize = xPad + regIconSize / (float)2;
        this.yStart = 0.0f;
        Log.d((String)this.tag, (String)("onSizeChanged: padding left = " + this.getPaddingLeft() + "; padding right = " + this.getPaddingRight() + "; padding top = " + this.getPaddingTop() + "; padding bottom = " + this.getPaddingBottom()));
        Log.d((String)this.tag, (String)("onSizeChanged: xStart = " + (this.getX() + this.xStart) + "; cornerSize = " + this.cornerSize + "; x = " + this.getX()));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.path.moveTo(this.xStart, this.yStart);
        this.path.lineTo(this.xStart + ((float)this.vWidth - (float)2 * this.cornerSize), this.yStart);
        this.rect.left = this.xStart + (float)this.vWidth - (float)2 * this.cornerSize;
        this.rect.right = this.rect.left + this.cornerSize;
        this.rect.top = this.yStart;
        this.rect.bottom = this.yStart + (float)this.vHeight;
        this.path.arcTo(this.rect, 270.0f, 180.0f);
        this.path.lineTo(this.xStart, this.yStart + (float)this.vHeight);
        this.rect.left = this.xStart - this.cornerSize;
        this.rect.right = this.xStart;
        this.rect.top = this.yStart;
        this.rect.bottom = this.yStart + (float)this.vHeight;
        this.path.arcTo(this.rect, 90.0f, 180.0f);
        this.path.close();
        canvas.drawPath(this.path, this.paint);
        this.path.reset();
    }

    public RoundedView(@NotNull Context context, @NotNull ReactionsConfig config) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(context);
        this.config = config;
        this.tag = RoundedView.class.getSimpleName();
        Paint paint2 = new Paint(1);
        RoundedView roundedView = this;
        Paint $receiver = paint2;
        $receiver.setColor(this.config.getPopupColor());
        $receiver.setStyle(Paint.Style.FILL);
        $receiver.setAlpha(230);
        roundedView.paint = paint = paint2;
        this.path = new Path();
        this.rect = new RectF();
    }
}

