/*
 * Decompiled with CFR 0.152.
 */
package io.zla.reactions;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import io.zla.reactions.Reaction;
import io.zla.reactions.ReactionLayoutTransition;
import io.zla.reactions.ReactionSelectedListener;
import io.zla.reactions.ReactionView;
import io.zla.reactions.ReactionViewGroup$WhenMappings;
import io.zla.reactions.ReactionsConfig;
import io.zla.reactions.RoundedView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010)\u001a\u00020*J\u001a\u0010+\u001a\u0004\u0018\u00010#2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\n\u0010/\u001a\u0004\u0018\u00010#H\u0002J\u0018\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020-H\u0002J\u0018\u00103\u001a\u00020*2\u0006\u00101\u001a\u00020\u000b2\u0006\u00104\u001a\u00020-H\u0002J0\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\rH\u0014J(\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\rH\u0014J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020BH\u0016J\u0006\u0010C\u001a\u00020*J\u0010\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020#H\u0002J\u0016\u0010F\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020HR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n '*\u0004\u0018\u00010&0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lio/zla/reactions/ReactionViewGroup;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "config", "Lio/zla/reactions/ReactionsConfig;", "(Landroid/content/Context;Lio/zla/reactions/ReactionsConfig;)V", "animators", "Ljava/util/ArrayList;", "Landroid/animation/Animator;", "background", "Lio/zla/reactions/RoundedView;", "cornerSize", "", "dialogHeight", "dialogWidth", "dialogX", "dialogY", "firstLayout", "", "horizontalPadding", "iconDivider", "largeIconSize", "mediumIconSize", "parentHeight", "parentLocation", "Landroid/graphics/Point;", "reactionSelectedListener", "Lio/zla/reactions/ReactionSelectedListener;", "getReactionSelectedListener", "()Lio/zla/reactions/ReactionSelectedListener;", "setReactionSelectedListener", "(Lio/zla/reactions/ReactionSelectedListener;)V", "reactions", "", "Lio/zla/reactions/ReactionView;", "smallIconSize", "tag", "", "kotlin.jvm.PlatformType", "verticalPadding", "dismiss", "", "getIntersectedIcon", "x", "", "y", "getSelectedIcon", "layoutIconView", "view", "v", "layoutRoundedView", "top", "onLayout", "changed", "l", "t", "r", "b", "onSizeChanged", "width", "height", "oldW", "oldH", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetChildrenToNormalSize", "setChildToLarge", "child", "show", "parent", "Landroid/view/View;", "android-reactions_release"})
@SuppressLint(value={"ViewConstructor"})
public final class ReactionViewGroup
extends ViewGroup {
    private final String tag;
    private final int horizontalPadding;
    private final int verticalPadding;
    private int dialogWidth;
    private int dialogHeight;
    private int iconDivider;
    private int smallIconSize;
    private int mediumIconSize;
    private int largeIconSize;
    private Point parentLocation;
    private int parentHeight;
    private int dialogX;
    private int dialogY;
    private int cornerSize;
    private boolean firstLayout;
    private final RoundedView background;
    private final List<ReactionView> reactions;
    @Nullable
    private ReactionSelectedListener reactionSelectedListener;
    private final ArrayList<Animator> animators;
    private final ReactionsConfig config;

    @Nullable
    public final ReactionSelectedListener getReactionSelectedListener() {
        return this.reactionSelectedListener;
    }

    public final void setReactionSelectedListener(@Nullable ReactionSelectedListener reactionSelectedListener) {
        this.reactionSelectedListener = reactionSelectedListener;
    }

    protected void onSizeChanged(int width, int height, int oldW, int oldH) {
        super.onSizeChanged(width, height, oldW, oldH);
        Log.d((String)this.tag, (String)("onSizeChanged: oldW = " + oldW + "; oldH = " + oldH + "; w = " + width + "; h = " + height));
        this.iconDivider = this.horizontalPadding / 2;
        int nIcons = this.config.getReactions().size();
        this.mediumIconSize = this.config.getReactionSize();
        this.dialogWidth = this.horizontalPadding * 2 + this.mediumIconSize * nIcons + this.iconDivider * (nIcons - 1);
        this.largeIconSize = 2 * this.mediumIconSize;
        this.smallIconSize = (this.dialogWidth - this.horizontalPadding * 2 - this.largeIconSize - this.iconDivider * (nIcons - 1)) / (nIcons - 1);
        this.dialogHeight = this.mediumIconSize + 2 * this.verticalPadding;
        this.cornerSize = this.horizontalPadding + this.mediumIconSize / 2;
        this.dialogX = this.parentLocation.x + this.cornerSize + this.horizontalPadding;
        if (this.dialogX + this.dialogWidth >= width) {
            this.dialogX = Math.max(0, (width - this.dialogWidth) / 2) + this.cornerSize;
        }
        this.dialogY = this.parentLocation.y - this.dialogHeight - this.parentHeight;
        if (this.parentHeight < 0) {
            this.dialogY = this.parentLocation.y + this.parentHeight;
        }
        this.setPadding(this.horizontalPadding, this.verticalPadding, this.horizontalPadding, this.verticalPadding);
    }

    /*
     * Unable to fully structure code
     */
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        Log.d((String)this.tag, (String)("onLayout: l = " + l + "; t = " + t + "; r = " + r + "; b = " + b));
        this.background.setPadding(this.horizontalPadding, this.verticalPadding, this.horizontalPadding, this.verticalPadding);
        this.animators.clear();
        var6_6 = 0;
        var7_8 = this.getChildCount();
        while (var6_6 < var7_8) {
            block12: {
                block10: {
                    block11: {
                        view = this.getChildAt((int)i);
                        var9_11 = view;
                        if (!(var9_11 instanceof ReactionView)) break block10;
                        switch (ReactionViewGroup$WhenMappings.$EnumSwitchMapping$0[((ReactionView)view).getMode().ordinal()]) {
                            case 1: {
                                v0 = this.smallIconSize;
                                break;
                            }
                            case 2: {
                                v0 = this.mediumIconSize;
                                break;
                            }
                            case 3: {
                                v0 = this.largeIconSize;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        targetSize = v0;
                        if (!this.firstLayout) break block11;
                        this.layoutIconView((ReactionView)view, targetSize);
                        break block12;
                    }
                    $receiver = var11_14 = ValueAnimator.ofFloat((float[])new float[]{((ReactionView)view).getWidth(), targetSize});
                    $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, view){
                        final /* synthetic */ ReactionViewGroup this$0;
                        final /* synthetic */ View $view$inlined;
                        {
                            this.this$0 = reactionViewGroup;
                            this.$view$inlined = view;
                        }

                        public final void onAnimationUpdate(ValueAnimator animation) {
                            ReactionView reactionView = (ReactionView)this.$view$inlined;
                            ValueAnimator valueAnimator = animation;
                            Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                            Object object = valueAnimator.getAnimatedValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                            }
                            ReactionViewGroup.access$layoutIconView(this.this$0, reactionView, ((Float)object).floatValue());
                        }
                    });
                    var15_17 = var11_14;
                    v1 = var14_16;
                    v2 = var15_17;
                    ** GOTO lbl-1000
                }
                if (var9_11 instanceof RoundedView) {
                    Log.d((String)this.tag, (String)("onLayout: dialogX = " + this.dialogX + "; cornerSize = " + this.cornerSize));
                    top = this.getSelectedIcon() != null ? this.dialogY + (this.mediumIconSize - this.smallIconSize) : this.dialogY;
                    if (this.firstLayout) {
                        this.layoutRoundedView((RoundedView)view, top);
                    } else {
                        $receiver = var11_14 = ValueAnimator.ofFloat((float[])new float[]{((RoundedView)view).getY(), top});
                        $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, view){
                            final /* synthetic */ ReactionViewGroup this$0;
                            final /* synthetic */ View $view$inlined;
                            {
                                this.this$0 = reactionViewGroup;
                                this.$view$inlined = view;
                            }

                            public final void onAnimationUpdate(ValueAnimator animation) {
                                RoundedView roundedView = (RoundedView)this.$view$inlined;
                                ValueAnimator valueAnimator = animation;
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                                Object object = valueAnimator.getAnimatedValue();
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                                }
                                ReactionViewGroup.access$layoutRoundedView(this.this$0, roundedView, ((Float)object).floatValue());
                            }
                        });
                        var15_17 = var11_14;
                        v1 = var14_16;
                        v2 = var15_17;
                    }
                }
                break block12;
lbl-1000:
                // 2 sources

                {
                    v1.add((Animator)v2);
                }
            }
            ++i;
        }
        if (!this.firstLayout) {
            $receiver = var6_7 = new AnimatorSet();
            $receiver.playTogether((Collection)this.animators);
            $receiver.setDuration(100L);
            var6_7.start();
        }
        this.firstLayout = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutIconView(ReactionView view, float v) {
        int prevX = 0;
        int n = 1;
        int n2 = this.indexOfChild((View)view);
        while (n < n2) {
            void i;
            View view2 = this.getChildAt((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"getChildAt(i)");
            prevX += view2.getWidth() + this.iconDivider;
            ++i;
        }
        int bottom = this.dialogY + this.dialogHeight - this.verticalPadding;
        int top = (int)((float)bottom - v);
        int left = this.dialogX - this.mediumIconSize / 2 + prevX;
        int right = (int)((float)left + v);
        view.layout(left, top, right, bottom);
    }

    private final void layoutRoundedView(RoundedView view, float top) {
        view.layout(this.dialogX - this.cornerSize, (int)top, this.dialogX + this.dialogWidth - this.cornerSize, this.dialogY + this.dialogHeight);
    }

    public final void show(@NotNull Point parentLocation, @NotNull View parent) {
        Intrinsics.checkParameterIsNotNull((Object)parentLocation, (String)"parentLocation");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        this.parentLocation = parentLocation;
        this.parentHeight = parent.getHeight();
        this.setVisibility(0);
        this.resetChildrenToNormalSize();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: 
            case 2: {
                ReactionView view = this.getIntersectedIcon(event.getRawX(), event.getRawY());
                if (view == null) {
                    this.resetChildrenToNormalSize();
                    break;
                }
                if (view.getMode() == ReactionView.Mode.LARGE) break;
                this.setChildToLarge(view);
                break;
            }
            case 1: {
                int n;
                Reaction reaction;
                ReactionView reactionView = this.getIntersectedIcon(event.getRawX(), event.getRawY());
                Reaction reaction2 = reaction = reactionView != null ? reactionView.getReaction() : null;
                if (reaction2 != null) {
                    Reaction reaction3;
                    Reaction it = reaction3 = reaction2;
                    n = CollectionsKt.indexOf((Iterable)this.config.getReactions(), (Object)it);
                } else {
                    n = -1;
                }
                int position = n;
                ReactionSelectedListener reactionSelectedListener = this.reactionSelectedListener;
                if (reactionSelectedListener != null) {
                    reactionSelectedListener.onReactionSelected(reaction, position);
                }
                this.dismiss();
                break;
            }
            case 3: {
                this.resetChildrenToNormalSize();
            }
        }
        return true;
    }

    public final void resetChildrenToNormalSize() {
        Iterable $receiver$iv = this.reactions;
        for (Object element$iv : $receiver$iv) {
            ReactionView it = (ReactionView)((Object)element$iv);
            it.setMode(ReactionView.Mode.MEDIUM);
        }
        this.requestLayout();
    }

    public final void dismiss() {
        this.parentLocation.set(0, 0);
        this.parentHeight = 0;
        this.setVisibility(8);
    }

    private final ReactionView getSelectedIcon() {
        Object v0;
        block1: {
            Iterable $receiver$iv = this.reactions;
            for (Object element$iv : $receiver$iv) {
                ReactionView it = (ReactionView)((Object)element$iv);
                if (!(it.getMode() == ReactionView.Mode.LARGE)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ReactionView getIntersectedIcon(float x, float y) {
        Object v0;
        block1: {
            Iterable $receiver$iv = this.reactions;
            for (Object element$iv : $receiver$iv) {
                ReactionView it = (ReactionView)((Object)element$iv);
                if (!(x >= (float)(it.getLocation().x - this.horizontalPadding) && x < (float)(it.getLocation().x + it.getWidth() + this.iconDivider) && y >= (float)(it.getLocation().y - this.horizontalPadding) && y < (float)(it.getLocation().y + it.getHeight() + this.iconDivider))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void setChildToLarge(ReactionView child) {
        Iterable $receiver$iv = this.reactions;
        for (Object element$iv : $receiver$iv) {
            ReactionView it;
            it.setMode(Intrinsics.areEqual((Object)((Object)(it = (ReactionView)((Object)element$iv))), (Object)((Object)child)) ? ReactionView.Mode.LARGE : ReactionView.Mode.SMALL);
        }
        this.requestLayout();
    }

    public ReactionViewGroup(@NotNull Context context, @NotNull ReactionsConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(context);
        this.config = config;
        this.tag = ReactionViewGroup.class.getSimpleName();
        this.horizontalPadding = this.config.getHorizontalMargin();
        this.verticalPadding = this.config.getVerticalMargin();
        this.parentLocation = new Point();
        this.firstLayout = true;
        this.background = new RoundedView(context, this.config);
        this.setLayoutTransition(new ReactionLayoutTransition());
        this.addView(this.background);
        ArrayList<ReactionView> arrayList = new ArrayList<ReactionView>(this.config.getReactions().size());
        ReactionViewGroup reactionViewGroup = this;
        ArrayList<ReactionView> list = arrayList;
        for (Reaction reaction : this.config.getReactions()) {
            ReactionView iconView = new ReactionView(context, reaction);
            this.addView((View)iconView);
            list.add(iconView);
        }
        ArrayList<ReactionView> arrayList2 = arrayList;
        reactionViewGroup.reactions = arrayList2;
        this.animators = new ArrayList(this.config.getReactions().size() + 1);
    }

    public static final /* synthetic */ void access$layoutIconView(ReactionViewGroup $this, @NotNull ReactionView view, float v) {
        $this.layoutIconView(view, v);
    }

    public static final /* synthetic */ void access$layoutRoundedView(ReactionViewGroup $this, @NotNull RoundedView view, float top) {
        $this.layoutRoundedView(view, top);
    }
}

