/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.ui;

import com.fasterxml.jackson.core.JsonGenerator;
import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RedirectService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import zipkin2.server.internal.JsonUtil;
import zipkin2.server.internal.ui.CompressionProperties;
import zipkin2.server.internal.ui.ZipkinUiProperties;

@EnableConfigurationProperties(value={ZipkinUiProperties.class, CompressionProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
public class ZipkinUiConfiguration {
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-lens/index.html")
    Resource lensIndexHtml;

    @Bean
    HttpService indexService() throws Exception {
        HttpService lensIndex = ZipkinUiConfiguration.maybeIndexService(this.ui.getBasepath(), this.lensIndexHtml);
        if (lensIndex != null) {
            return lensIndex;
        }
        throw new BeanCreationException("Could not load Lens UI from " + this.lensIndexHtml);
    }

    @Bean
    ArmeriaServerConfigurator uiServerConfigurator(HttpService indexService, Optional<MeterRegistry> meterRegistry) throws IOException {
        ServerCacheControl maxAgeYear = ServerCacheControl.builder().maxAgeSeconds(TimeUnit.DAYS.toSeconds(365L)).build();
        FileService uiFileService = FileService.builder((ClassLoader)this.getClass().getClassLoader(), (String)"zipkin-lens").cacheControl((CacheControl)maxAgeYear).build();
        String config = ZipkinUiConfiguration.writeConfig(this.ui);
        return arg_0 -> ZipkinUiConfiguration.lambda$uiServerConfigurator$2(config, (HttpService)uiFileService, indexService, meterRegistry, arg_0);
    }

    static String writeConfig(ZipkinUiProperties ui) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = JsonUtil.createGenerator(writer);){
            generator.useDefaultPrettyPrinter();
            generator.writeStartObject();
            generator.writeStringField("environment", ui.getEnvironment());
            generator.writeNumberField("queryLimit", ui.getQueryLimit());
            generator.writeNumberField("defaultLookback", ui.getDefaultLookback());
            generator.writeBooleanField("searchEnabled", ui.isSearchEnabled());
            generator.writeStringField("logsUrl", ui.getLogsUrl());
            generator.writeStringField("supportUrl", ui.getSupportUrl());
            generator.writeStringField("archivePostUrl", ui.getArchivePostUrl());
            generator.writeStringField("archiveUrl", ui.getArchiveUrl());
            generator.writeObjectFieldStart("dependency");
            generator.writeBooleanField("enabled", ui.getDependency().isEnabled());
            generator.writeNumberField("lowErrorRate", ui.getDependency().getLowErrorRate());
            generator.writeNumberField("highErrorRate", ui.getDependency().getHighErrorRate());
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return writer.toString();
    }

    static HttpService maybeIndexService(String basePath, Resource resource) throws IOException {
        String maybeContent = ZipkinUiConfiguration.maybeResource(basePath, resource);
        if (maybeContent == null) {
            return null;
        }
        ServerCacheControl maxAgeMinute = ServerCacheControl.builder().maxAgeSeconds(60L).build();
        return HttpFile.builder((HttpData)HttpData.ofUtf8((String)maybeContent)).contentType(MediaType.HTML_UTF_8).cacheControl((CacheControl)maxAgeMinute).build().asService();
    }

    static String maybeResource(String basePath, Resource resource) throws IOException {
        if (!resource.isReadable()) {
            return null;
        }
        try (InputStream stream = resource.getInputStream();){
            String content = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            if ("/zipkin".equals(basePath)) {
                String string = content;
                return string;
            }
            if (basePath.equals("/")) {
                basePath = "";
            }
            String string = content.replace("=\"/zipkin", "=\".").replace("<base href=\".", "<base href=\"" + basePath);
            return string;
        }
    }

    private static /* synthetic */ void lambda$uiServerConfigurator$2(String config, HttpService uiFileService, HttpService indexService, Optional meterRegistry, ServerBuilder sb) {
        sb.service("/zipkin/config.json", HttpFile.builder((HttpData)HttpData.ofUtf8((String)config)).cacheControl((CacheControl)ServerCacheControl.builder().maxAgeSeconds(600L).build()).contentType(MediaType.JSON_UTF_8).build().asService());
        sb.serviceUnder("/zipkin/", uiFileService);
        sb.service("/zipkin/", indexService).service("/zipkin/index.html", indexService).service("/zipkin/traces/{id}", indexService).service("/zipkin/dependency", indexService).service("/zipkin/traceViewer", indexService);
        sb.service("/favicon.ico", (HttpService)new RedirectService(HttpStatus.FOUND, "/zipkin/favicon.ico")).service("/", (HttpService)new RedirectService(HttpStatus.FOUND, "/zipkin/")).service("/zipkin", (HttpService)new RedirectService(HttpStatus.FOUND, "/zipkin/"));
        meterRegistry.ifPresent(m -> m.config().meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && uri.startsWith("/favicon.ico");
        })));
    }
}

