/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.mysql;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ThreadLocalSpan;
import com.linecorp.armeria.common.RequestContext;
import java.util.concurrent.Executor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.mysql.ZipkinMySQLStorageConfiguration;
import zipkin2.server.internal.mysql.ZipkinMySQLStorageProperties;

@ConditionalOnSelfTracing
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
class ZipkinSelfTracingMySQLStorageConfiguration
extends DefaultExecuteListener {
    @Autowired
    ZipkinMySQLStorageProperties mysql;
    @Autowired
    CurrentTraceContext currentTraceContext;
    @Autowired
    ThreadLocalSpan threadLocalSpan;

    ZipkinSelfTracingMySQLStorageConfiguration() {
    }

    @Bean
    ExecuteListenerProvider mysqlListener() {
        return new DefaultExecuteListenerProvider((ExecuteListener)this);
    }

    @Bean
    Executor mysqlExecutor() {
        return ZipkinSelfTracingMySQLStorageConfiguration.makeContextAware(new ZipkinMySQLStorageConfiguration().mysqlExecutor(), this.currentTraceContext);
    }

    static Executor makeContextAware(final Executor delegate, final CurrentTraceContext currentTraceContext) {
        class TracingCurrentRequestContextExecutor
        implements Executor {
            TracingCurrentRequestContextExecutor() {
            }

            @Override
            public void execute(Runnable task) {
                delegate.execute(RequestContext.current().makeContextAware(currentTraceContext.wrap(task)));
            }
        }
        return new TracingCurrentRequestContextExecutor();
    }

    public void renderEnd(ExecuteContext ctx) {
        if (this.currentTraceContext.get() == null) {
            return;
        }
        Span span = this.threadLocalSpan.next();
        if (span == null || span.isNoop()) {
            return;
        }
        String sql = ctx.sql();
        int spaceIndex = sql.indexOf(32);
        span.kind(Span.Kind.CLIENT).name(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        span.tag("sql.query", sql);
        span.remoteServiceName("mysql");
        span.remoteIpAndPort(this.mysql.getHost(), this.mysql.getPort());
        span.start();
    }

    public void executeEnd(ExecuteContext ctx) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (ctx.sqlException() != null) {
            span.error((Throwable)ctx.sqlException());
        }
        span.finish();
    }
}

