/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public final class ZipkinActuatorImporter
implements ApplicationContextInitializer<GenericApplicationContext> {
    static final Logger LOG = LoggerFactory.getLogger(ZipkinActuatorImporter.class);
    static final String ACTUATOR_IMPL_CLASS = "com.linecorp.armeria.spring.actuate.ArmeriaSpringActuatorAutoConfiguration";
    static final String PROPERTY_NAME_ACTUATOR_ENABLED = "zipkin.internal.actuator.enabled";
    static final String PROPERTY_NAME_ACTUATOR_INCLUDE = "zipkin.internal.actuator.include";
    final String actuatorImplClass;

    public ZipkinActuatorImporter() {
        this(ACTUATOR_IMPL_CLASS);
    }

    ZipkinActuatorImporter(String actuatorImplClass) {
        this.actuatorImplClass = actuatorImplClass;
    }

    public void initialize(GenericApplicationContext context) {
        ConfigurableEnvironment env = context.getEnvironment();
        if ("false".equalsIgnoreCase(env.getProperty(PROPERTY_NAME_ACTUATOR_ENABLED))) {
            LOG.debug("skipping actuator as it is disabled");
            return;
        }
        Object[] includes = (String[])Binder.get((Environment)env).bind(PROPERTY_NAME_ACTUATOR_INCLUDE, String[].class).orElse(null);
        if (includes == null || includes.length == 0) {
            LOG.debug("no actuator configuration found under path {}", (Object)PROPERTY_NAME_ACTUATOR_INCLUDE);
            return;
        }
        LOG.debug("attempting to load actuator configuration: {}", (Object)Arrays.toString(includes));
        try {
            context.registerBean(Class.forName(this.actuatorImplClass), new BeanDefinitionCustomizer[0]);
        }
        catch (Exception e) {
            LOG.debug("skipping actuator as implementation is not available", (Throwable)e);
            return;
        }
        for (Object include : includes) {
            try {
                context.registerBean(Class.forName((String)include), new BeanDefinitionCustomizer[0]);
            }
            catch (Exception e) {
                LOG.debug("skipping unloadable actuator config {}", include, (Object)e);
            }
        }
    }
}

