/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.brave;

import brave.ScopedSpan;
import brave.Span;
import brave.Tracer;
import java.io.IOException;
import zipkin2.Call;
import zipkin2.Callback;

public final class TracedCall<V>
extends Call<V> {
    final Tracer tracer;
    final Call<V> delegate;
    final String name;

    public TracedCall(Tracer tracer, Call<V> delegate, String name) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.name = name;
    }

    public V execute() throws IOException {
        ScopedSpan span = this.tracer.startScopedSpan(this.name);
        try {
            Object object = this.delegate.execute();
            return (V)object;
        }
        catch (IOException | Error | RuntimeException e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void enqueue(Callback<V> callback) {
        Span span = this.tracer.nextSpan().name(this.name).start();
        try {
            if (span.isNoop()) {
                this.delegate.enqueue(callback);
            } else {
                this.delegate.enqueue(new SpanFinishingCallback<V>(callback, span));
            }
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            span.finish();
            throw e;
        }
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public Call<V> clone() {
        return new TracedCall<V>(this.tracer, this.delegate, this.name);
    }

    public String toString() {
        return "Traced(" + this.delegate + ")";
    }

    static final class SpanFinishingCallback<V>
    implements Callback<V> {
        private final Callback<V> delegate;
        private final Span span;

        SpanFinishingCallback(Callback<V> delegate, Span span) {
            this.delegate = delegate;
            this.span = span;
        }

        public void onSuccess(V value) {
            this.delegate.onSuccess(value);
            this.span.finish();
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
            this.span.error(t).finish();
        }

        public String toString() {
            return "Traced(" + this.delegate + ")";
        }
    }
}

