/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.metric.MetricCollectingClient;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Supplier;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;

final class LazyHttpClientImpl
implements ElasticsearchStorage.LazyHttpClient {
    final HttpClientFactory factory;
    final SessionProtocol protocol;
    final Supplier<EndpointGroup> initialEndpoints;
    final ZipkinElasticsearchStorageProperties.HealthCheck healthCheck;
    final int timeoutMillis;
    final MeterRegistry meterRegistry;
    volatile WebClient result;

    LazyHttpClientImpl(HttpClientFactory factory, SessionProtocol protocol, Supplier<EndpointGroup> initialEndpoints, ZipkinElasticsearchStorageProperties es, MeterRegistry meterRegistry) {
        this.factory = factory;
        this.protocol = protocol;
        this.initialEndpoints = initialEndpoints;
        this.healthCheck = es.getHealthCheck();
        this.timeoutMillis = es.getTimeout();
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebClient get() {
        if (this.result == null) {
            LazyHttpClientImpl lazyHttpClientImpl = this;
            synchronized (lazyHttpClientImpl) {
                if (this.result == null) {
                    this.result = this.factory.apply(this.getEndpoint());
                }
            }
        }
        return this.result;
    }

    EndpointGroup getEndpoint() {
        EndpointGroup initial = this.initialEndpoints.get();
        if (initial instanceof Endpoint || !this.healthCheck.isEnabled()) {
            return initial;
        }
        return this.decorateHealthCheck(initial);
    }

    HealthCheckedEndpointGroup decorateHealthCheck(EndpointGroup endpointGroup) {
        HealthCheckedEndpointGroup healthChecked = HealthCheckedEndpointGroup.builder((EndpointGroup)endpointGroup, (String)"/_cluster/health").protocol(this.protocol).useGet(true).clientFactory(this.factory.clientFactory).withClientOptions(options -> {
            this.factory.configureHttpLogging(this.healthCheck.getHttpLogging(), (ClientOptionsBuilder)options);
            this.factory.configureOptionsExceptHttpLogging((ClientOptionsBuilder)options);
            options.decorator(MetricCollectingClient.newDecorator((MeterIdPrefixFunction)MeterIdPrefixFunction.ofDefault((String)"elasticsearch-healthcheck")));
            options.decorator((delegate, ctx, req) -> {
                ctx.logBuilder().name("health-check");
                return delegate.execute(ctx, req);
            });
            return options;
        }).retryInterval(this.healthCheck.getInterval()).build();
        healthChecked.newMeterBinder("elasticsearch").bindTo(this.meterRegistry);
        return healthChecked;
    }

    public final String toString() {
        return this.initialEndpoints.toString();
    }
}

