/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Logger;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import zipkin2.elasticsearch.ElasticsearchStorage;

@ConfigurationProperties(value="zipkin.storage.elasticsearch")
class ZipkinElasticsearchStorageProperties
implements Serializable {
    static final Logger log = Logger.getLogger(ZipkinElasticsearchStorageProperties.class.getName());
    private static final long serialVersionUID = 0L;
    private String pipeline;
    private String hosts = "http://localhost:9200";
    private String index;
    private String dateSeparator;
    private Integer indexShards;
    private Integer indexReplicas;
    private String username;
    private String password;
    private HttpLogging httpLogging = HttpLogging.NONE;
    private Integer timeout = 10000;
    private Ssl ssl = new Ssl();
    private Integer maxRequests;
    private HealthCheck healthCheck = new HealthCheck();

    ZipkinElasticsearchStorageProperties() {
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = ZipkinElasticsearchStorageProperties.emptyToNull(pipeline);
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = ZipkinElasticsearchStorageProperties.emptyToNull(hosts);
    }

    public String getIndex() {
        return this.index;
    }

    public Integer getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(Integer maxRequests) {
        this.maxRequests = maxRequests;
    }

    public void setIndex(String index) {
        this.index = ZipkinElasticsearchStorageProperties.emptyToNull(index);
    }

    public Integer getIndexShards() {
        return this.indexShards;
    }

    public void setIndexShards(Integer indexShards) {
        this.indexShards = indexShards;
    }

    public String getDateSeparator() {
        return this.dateSeparator;
    }

    public void setDateSeparator(String dateSeparator) {
        String trimmed = dateSeparator.trim();
        if (trimmed.length() > 1) {
            throw new IllegalArgumentException("dateSeparator must be empty or a single character");
        }
        this.dateSeparator = dateSeparator;
    }

    public Integer getIndexReplicas() {
        return this.indexReplicas;
    }

    public void setIndexReplicas(Integer indexReplicas) {
        this.indexReplicas = indexReplicas;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = ZipkinElasticsearchStorageProperties.emptyToNull(username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = ZipkinElasticsearchStorageProperties.emptyToNull(password);
    }

    public HttpLogging getHttpLogging() {
        return this.httpLogging;
    }

    public void setHttpLogging(HttpLogging httpLogging) {
        this.httpLogging = httpLogging;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public ElasticsearchStorage.Builder toBuilder(ElasticsearchStorage.LazyHttpClient httpClient) {
        ElasticsearchStorage.Builder builder = ElasticsearchStorage.newBuilder((ElasticsearchStorage.LazyHttpClient)httpClient);
        if (this.index != null) {
            builder.index(this.index);
        }
        if (this.dateSeparator != null) {
            builder.dateSeparator(this.dateSeparator.isEmpty() ? (char)'\u0000' : this.dateSeparator.charAt(0));
        }
        if (this.pipeline != null) {
            builder.pipeline(this.pipeline);
        }
        if (this.indexShards != null) {
            builder.indexShards(this.indexShards.intValue());
        }
        if (this.indexReplicas != null) {
            builder.indexReplicas(this.indexReplicas.intValue());
        }
        if (this.maxRequests != null) {
            log.warning("ES_MAX_REQUESTS is no longer honored. Use STORAGE_THROTTLE_ENABLED instead");
        }
        return builder;
    }

    private static String emptyToNull(String s) {
        return "".equals(s) ? null : s;
    }

    static /* synthetic */ String access$000(String x0) {
        return ZipkinElasticsearchStorageProperties.emptyToNull(x0);
    }

    static enum HttpLogging {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }

    public static class Ssl {
        private String keyStore = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.keyStore"));
        private String keyStorePassword = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.keyStorePassword"));
        private String keyStoreType = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.keyStoreType"));
        private String trustStore = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.trustStore"));
        private String trustStorePassword = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.trustStorePassword"));
        private String trustStoreType = ZipkinElasticsearchStorageProperties.access$000(System.getProperty("javax.net.ssl.trustStoreType"));

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }
    }

    public static class HealthCheck {
        private boolean enabled = true;
        @DurationUnit(value=ChronoUnit.MILLIS)
        private Duration interval = Duration.ofSeconds(3L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getInterval() {
            return this.interval;
        }

        public void setInterval(Duration interval) {
            this.interval = interval;
        }
    }
}

