/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.health;

import com.fasterxml.jackson.core.JsonGenerator;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import zipkin2.Component;
import zipkin2.server.internal.JsonUtil;
import zipkin2.server.internal.ZipkinHttpConfiguration;
import zipkin2.server.internal.health.ComponentHealth;

public class ZipkinHealthController {
    final List<Component> components;

    ZipkinHealthController(List<Component> components) {
        this.components = components;
    }

    @Get(value="/actuator/health")
    public CompletableFuture<HttpResponse> getActuatorHealth(ServiceRequestContext ctx) {
        return this.health(ctx, ZipkinHttpConfiguration.MEDIA_TYPE_ACTUATOR);
    }

    @Get(value="/health")
    public CompletableFuture<HttpResponse> getHealth(ServiceRequestContext ctx) {
        return this.health(ctx, MediaType.JSON_UTF_8);
    }

    CompletableFuture<HttpResponse> health(ServiceRequestContext ctx, MediaType mediaType) {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        ctx.setRequestTimeoutHandler(() -> {
            try {
                String healthJson = ZipkinHealthController.writeJsonError("Timed out computing health status. This often means your storage backend is unreachable.");
                responseFuture.complete(ZipkinHealthController.newHealthResponse("DOWN", mediaType, healthJson));
            }
            catch (Throwable e) {
                responseFuture.completeExceptionally(e);
            }
        });
        List<CompletableFuture> futures = this.components.stream().map(component -> CompletableFuture.supplyAsync(() -> ComponentHealth.ofComponent(component), ctx.blockingTaskExecutor())).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).handle((unused, t) -> {
            if (t != null) {
                responseFuture.completeExceptionally((Throwable)t);
            } else {
                responseFuture.complete(ZipkinHealthController.newHealthResponse(futures.stream().map(CompletableFuture::join).collect(Collectors.toList()), mediaType));
            }
            return null;
        });
        return responseFuture;
    }

    static HttpResponse newHealthResponse(List<ComponentHealth> healths, MediaType mediaType) {
        String healthJson;
        String overallStatus = "UP";
        for (ComponentHealth health : healths) {
            if (!health.status.equals("DOWN")) continue;
            overallStatus = "DOWN";
        }
        try {
            healthJson = ZipkinHealthController.writeJson(overallStatus, healths);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return ZipkinHealthController.newHealthResponse(overallStatus, mediaType, healthJson);
    }

    static HttpResponse newHealthResponse(String status, MediaType mediaType, String healthJson) {
        HttpStatus code = status.equals("UP") ? HttpStatus.OK : HttpStatus.SERVICE_UNAVAILABLE;
        return HttpResponse.of((HttpStatus)code, (MediaType)mediaType, (String)healthJson);
    }

    static String writeJsonError(String error) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = JsonUtil.createGenerator(writer);){
            generator.writeStartObject();
            generator.writeStringField("status", "DOWN");
            generator.writeObjectFieldStart("zipkin");
            generator.writeStringField("status", "DOWN");
            generator.writeObjectFieldStart("details");
            generator.writeStringField("error", error);
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return writer.toString();
    }

    static String writeJson(String overallStatus, List<ComponentHealth> healths) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = JsonUtil.createGenerator(writer);){
            generator.writeStartObject();
            generator.writeStringField("status", overallStatus);
            generator.writeObjectFieldStart("zipkin");
            generator.writeStringField("status", overallStatus);
            generator.writeObjectFieldStart("details");
            for (ComponentHealth health : healths) {
                generator.writeObjectFieldStart(health.name);
                generator.writeStringField("status", health.status);
                if (health.status.equals("DOWN")) {
                    generator.writeObjectFieldStart("details");
                    generator.writeStringField("error", health.error);
                    generator.writeEndObject();
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return writer.toString();
    }
}

