/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ConsumesJson;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Post;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.Span;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.BodyIsExceptionMessage;
import zipkin2.server.internal.CompletableCallback;
import zipkin2.server.internal.ConsumesProtobuf;
import zipkin2.server.internal.ConsumesThrift;
import zipkin2.server.internal.UnzippingBytesRequestConverter;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.collector.http.enabled"}, matchIfMissing=true)
@ExceptionHandler(value=BodyIsExceptionMessage.class)
public class ZipkinHttpCollector {
    static final Logger LOGGER = LoggerFactory.getLogger(ZipkinHttpCollector.class);
    static volatile CollectorMetrics metrics;
    final Collector collector;
    static final byte[] BINARY_ANNOTATION_FIELD_SUFFIX;
    static final byte[] ENDPOINT_FIELD_SUFFIX;
    static final byte[] TAGS_FIELD;

    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        metrics = metrics.forTransport("http");
        this.collector = Collector.newBuilder(this.getClass()).storage(storage).sampler(sampler).metrics(metrics).build();
        ZipkinHttpCollector.metrics = metrics;
    }

    @Post(value="/api/v2/spans")
    public HttpResponse uploadSpans(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesJson
    public HttpResponse uploadSpansJson(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V2, ctx, req);
    }

    @Post(value="/api/v2/spans")
    @ConsumesProtobuf
    public HttpResponse uploadSpansProtobuf(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.PROTO3, ctx, req);
    }

    @Post(value="/api/v1/spans")
    public HttpResponse uploadSpansV1(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesJson
    public HttpResponse uploadSpansV1Json(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.JSON_V1, ctx, req);
    }

    @Post(value="/api/v1/spans")
    @ConsumesThrift
    public HttpResponse uploadSpansV1Thrift(ServiceRequestContext ctx, HttpRequest req) {
        return this.validateAndStoreSpans(SpanBytesDecoder.THRIFT, ctx, req);
    }

    HttpResponse validateAndStoreSpans(SpanBytesDecoder decoder, ServiceRequestContext ctx, HttpRequest req) {
        CompletableCallback result = new CompletableCallback();
        req.aggregateWithPooledObjects((EventExecutor)ctx.contextAwareEventLoop(), ctx.alloc()).handle((msg, t) -> {
            block17: {
                HttpData content;
                if (t != null) {
                    result.onError((Throwable)t);
                    return null;
                }
                try {
                    content = UnzippingBytesRequestConverter.convertRequest(ctx, msg);
                }
                catch (Throwable t1) {
                    Call.propagateIfFatal((Throwable)t1);
                    result.onError(t1);
                    return null;
                }
                try {
                    if (content.isEmpty()) {
                        result.onSuccess(null);
                        Object t1 = null;
                        return t1;
                    }
                    ByteBuffer nioBuffer = content instanceof ByteBufHolder ? ((ByteBufHolder)content).content().nioBuffer() : ByteBuffer.wrap(content.array());
                    try {
                        SpanBytesDecoderDetector.decoderForListMessage((ByteBuffer)nioBuffer);
                    }
                    catch (IllegalArgumentException e) {
                        result.onError(new IllegalArgumentException("Expected a " + decoder + " encoded list\n"));
                        Object var9_13 = null;
                        ReferenceCountUtil.release((Object)content);
                        return var9_13;
                    }
                    catch (Throwable t1) {
                        result.onError(t1);
                        Object var9_14 = null;
                        ReferenceCountUtil.release((Object)content);
                        return var9_14;
                    }
                    SpanBytesDecoder unexpectedDecoder = ZipkinHttpCollector.testForUnexpectedFormat((BytesDecoder<Span>)decoder, nioBuffer);
                    if (unexpectedDecoder != null) {
                        result.onError(new IllegalArgumentException("Expected a " + decoder + " encoded list, but received: " + unexpectedDecoder + "\n"));
                        Object var9_15 = null;
                        return var9_15;
                    }
                    ExecutorService executor = ctx.makeContextAware(ctx.blockingTaskExecutor());
                    try {
                        this.collector.acceptSpans(nioBuffer, decoder, (Callback)result, (Executor)executor);
                        break block17;
                    }
                    catch (Throwable t1) {
                        result.onError(t1);
                        Object var11_18 = null;
                        ReferenceCountUtil.release((Object)content);
                        return var11_18;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)content);
                }
            }
            return null;
        });
        return HttpResponse.from((CompletionStage)result);
    }

    static void maybeLog(String prefix, ServiceRequestContext ctx, AggregatedHttpRequest request) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("{} sent by clientAddress->{}, userAgent->{}", new Object[]{prefix, ctx.clientAddress(), request.headers().get((CharSequence)HttpHeaderNames.USER_AGENT)});
    }

    static SpanBytesDecoder testForUnexpectedFormat(BytesDecoder<Span> decoder, ByteBuffer body) {
        if (decoder == SpanBytesDecoder.JSON_V2) {
            if (ZipkinHttpCollector.contains(body, BINARY_ANNOTATION_FIELD_SUFFIX)) {
                return SpanBytesDecoder.JSON_V1;
            }
        } else if (decoder == SpanBytesDecoder.JSON_V1 && (ZipkinHttpCollector.contains(body, ENDPOINT_FIELD_SUFFIX) || ZipkinHttpCollector.contains(body, TAGS_FIELD))) {
            return SpanBytesDecoder.JSON_V2;
        }
        return null;
    }

    static boolean contains(ByteBuffer bytes, byte[] subsequence) {
        block0: for (int i = 0; i < bytes.remaining() - subsequence.length + 1; ++i) {
            for (int j = 0; j < subsequence.length; ++j) {
                if (bytes.get(bytes.position() + i + j) != subsequence[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    static {
        BINARY_ANNOTATION_FIELD_SUFFIX = new byte[]{121, 65, 110, 110, 111, 116, 97, 116, 105, 111, 110, 115, 34};
        ENDPOINT_FIELD_SUFFIX = new byte[]{69, 110, 100, 112, 111, 105, 110, 116, 34};
        TAGS_FIELD = new byte[]{34, 116, 97, 103, 115, 34};
    }
}

