/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import brave.Tracing;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.ConditionalOnThrottledStorage;
import zipkin2.server.internal.MicrometerCollectorMetrics;
import zipkin2.server.internal.brave.TracingStorageComponent;
import zipkin2.server.internal.throttle.ThrottledStorageComponent;
import zipkin2.server.internal.throttle.ZipkinStorageThrottleProperties;
import zipkin2.storage.InMemoryStorage;
import zipkin2.storage.StorageComponent;

@Configuration
public class ZipkinConfiguration {
    @Bean
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    CollectorMetrics metrics(MeterRegistry registry) {
        return new MicrometerCollectorMetrics(registry);
    }

    static final class StorageTypeMemAbsentOrEmpty
    implements Condition {
        StorageTypeMemAbsentOrEmpty() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String storageType = condition.getEnvironment().getProperty("zipkin.storage.type");
            if (storageType == null) {
                return true;
            }
            if ((storageType = storageType.trim()).isEmpty()) {
                return true;
            }
            return storageType.equals("mem");
        }
    }

    @Configuration
    @Conditional(value={StorageTypeMemAbsentOrEmpty.class})
    @ConditionalOnMissingBean(value={StorageComponent.class})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Bean
        StorageComponent storage(@Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.mem.max-spans:500000}") int maxSpans, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
            return InMemoryStorage.newBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).maxSpanCount(maxSpans).autocompleteKeys(autocompleteKeys).build();
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class TracingStorageComponentEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Tracing tracing;

        TracingStorageComponentEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (this.tracing == null) {
                return bean;
            }
            if (bean instanceof StorageComponent) {
                return new TracingStorageComponent(this.tracing, (StorageComponent)bean);
            }
            return bean;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ZipkinStorageThrottleProperties.class})
    @ConditionalOnThrottledStorage
    static class ThrottledStorageComponentEnhancer
    implements BeanPostProcessor,
    BeanFactoryAware {
        @Autowired(required=false)
        Tracing tracing;
        private BeanFactory beanFactory;

        ThrottledStorageComponentEnhancer() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof StorageComponent) {
                ZipkinStorageThrottleProperties throttleProperties = (ZipkinStorageThrottleProperties)this.beanFactory.getBean(ZipkinStorageThrottleProperties.class);
                return new ThrottledStorageComponent((StorageComponent)bean, (MeterRegistry)this.beanFactory.getBean(MeterRegistry.class), this.tracing, throttleProperties.getMinConcurrency(), throttleProperties.getMaxConcurrency(), throttleProperties.getMaxQueueSize());
            }
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

