/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.ui;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.ServerCacheControlBuilder;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RedirectService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.HttpFileServiceBuilder;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import zipkin2.server.internal.ui.CompressionProperties;
import zipkin2.server.internal.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class, CompressionProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
public class ZipkinUiConfiguration {
    static final JsonFactory JSON_FACTORY = new JsonFactory();
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource classicIndexHtml;
    @Value(value="classpath:zipkin-lens/index.html")
    Resource lensIndexHtml;

    @Bean
    HttpService indexService() throws IOException {
        HttpService lensIndex = ZipkinUiConfiguration.maybeIndexService(this.ui.getBasepath(), this.lensIndexHtml);
        HttpService classicIndex = ZipkinUiConfiguration.maybeIndexService(this.ui.getBasepath(), this.classicIndexHtml);
        if (lensIndex != null && classicIndex != null) {
            return new IndexSwitchingService(classicIndex, lensIndex);
        }
        if (lensIndex != null) {
            return lensIndex;
        }
        throw new BeanCreationException("Could not load Lens UI from " + this.lensIndexHtml);
    }

    @Bean
    ArmeriaServerConfigurator uiServerConfigurator(HttpService indexService, Optional<MeterRegistry> meterRegistry) throws IOException {
        ServerCacheControl maxAgeYear = new ServerCacheControlBuilder().maxAgeSeconds(TimeUnit.DAYS.toSeconds(365L)).build();
        Object uiFileService = indexService instanceof IndexSwitchingService ? HttpFileServiceBuilder.forClassPath((String)"zipkin-ui").cacheControl((CacheControl)maxAgeYear).build().orElse((Service)HttpFileServiceBuilder.forClassPath((String)"zipkin-lens").cacheControl((CacheControl)maxAgeYear).build()) : HttpFileServiceBuilder.forClassPath((String)"zipkin-lens").cacheControl((CacheControl)maxAgeYear).build();
        String config = ZipkinUiConfiguration.writeConfig(this.ui);
        return arg_0 -> ZipkinUiConfiguration.lambda$uiServerConfigurator$2(config, (HttpService)uiFileService, indexService, meterRegistry, arg_0);
    }

    static String writeConfig(ZipkinUiProperties ui) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = JSON_FACTORY.createGenerator((Writer)writer);
        generator.useDefaultPrettyPrinter();
        generator.writeStartObject();
        generator.writeStringField("environment", ui.getEnvironment());
        generator.writeBooleanField("suggestLens", ui.isSuggestLens());
        generator.writeNumberField("queryLimit", ui.getQueryLimit());
        generator.writeNumberField("defaultLookback", ui.getDefaultLookback());
        generator.writeBooleanField("searchEnabled", ui.isSearchEnabled());
        generator.writeObjectFieldStart("dependency");
        generator.writeNumberField("lowErrorRate", ui.getDependency().getLowErrorRate());
        generator.writeNumberField("highErrorRate", ui.getDependency().getHighErrorRate());
        generator.writeEndObject();
        generator.writeEndObject();
        generator.flush();
        return writer.toString();
    }

    static HttpService maybeIndexService(String basePath, Resource resource) throws IOException {
        String maybeContent = ZipkinUiConfiguration.maybeResource(basePath, resource);
        if (maybeContent == null) {
            return null;
        }
        ServerCacheControl maxAgeMinute = new ServerCacheControlBuilder().maxAgeSeconds(60L).build();
        return HttpFileBuilder.of((HttpData)HttpData.ofUtf8((String)maybeContent)).contentType(MediaType.HTML_UTF_8).cacheControl((CacheControl)maxAgeMinute).build().asService();
    }

    static String maybeResource(String basePath, Resource resource) throws IOException {
        if (!resource.isReadable()) {
            return null;
        }
        try (InputStream stream = resource.getInputStream();){
            String content = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            if ("/zipkin".equals(basePath)) {
                String string = content;
                return string;
            }
            String baseTagValue = "/".equals(basePath) ? "/" : basePath + "/";
            String string = content.replaceAll("base href=\"[^\"]+\"", "base href=\"" + baseTagValue + "\"");
            return string;
        }
    }

    private static /* synthetic */ void lambda$uiServerConfigurator$2(String config, HttpService uiFileService, HttpService indexService, Optional meterRegistry, ServerBuilder sb) {
        sb.service("/zipkin/config.json", (Service)HttpFileBuilder.of((HttpData)HttpData.ofUtf8((String)config)).cacheControl((CacheControl)new ServerCacheControlBuilder().maxAgeSeconds(600L).build()).contentType(MediaType.JSON_UTF_8).build().asService());
        sb.serviceUnder("/zipkin/", (Service)uiFileService);
        sb.service("/zipkin/", (Service)indexService).service("/zipkin/index.html", (Service)indexService).service("/zipkin/traces/{id}", (Service)indexService).service("/zipkin/dependency", (Service)indexService).service("/zipkin/traceViewer", (Service)indexService);
        sb.service("/favicon.ico", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/favicon.ico")).service("/", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/")).service("/zipkin", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/"));
        meterRegistry.ifPresent(m -> m.config().meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && uri.startsWith("/favicon.ico");
        })));
    }

    static class IndexSwitchingService
    extends AbstractHttpService {
        final HttpService legacyIndex;
        final HttpService lensIndex;

        IndexSwitchingService(HttpService legacyIndex, HttpService lensIndex) {
            this.legacyIndex = legacyIndex;
            this.lensIndex = lensIndex;
        }

        public HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            Set cookies = ServerCookieDecoder.LAX.decode(req.headers().get((CharSequence)HttpHeaderNames.COOKIE, ""));
            for (Cookie cookie : cookies) {
                if (!cookie.name().equals("lens") || !Boolean.parseBoolean(cookie.value())) continue;
                return this.lensIndex.serve(ctx, req);
            }
            return this.legacyIndex.serve(ctx, req);
        }
    }
}

