/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointGroupRegistry;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.metric.MetricCollectingClient;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;

final class LazyHttpClientImpl
implements ElasticsearchStorage.LazyHttpClient {
    final HttpClientFactory factory;
    final SessionProtocol protocol;
    final Supplier<EndpointGroup> initialEndpoints;
    final ZipkinElasticsearchStorageProperties.HealthCheck healthCheck;
    final int timeoutMillis;
    final MeterRegistry meterRegistry;
    volatile HttpClient result;

    LazyHttpClientImpl(HttpClientFactory factory, SessionProtocol protocol, Supplier<EndpointGroup> initialEndpoints, ZipkinElasticsearchStorageProperties es, MeterRegistry meterRegistry) {
        this.factory = factory;
        this.protocol = protocol;
        this.initialEndpoints = initialEndpoints;
        this.healthCheck = es.getHealthCheck();
        this.timeoutMillis = es.getTimeout();
        this.meterRegistry = meterRegistry;
    }

    public void close() {
        EndpointGroup endpointGroup = EndpointGroupRegistry.get((String)"elasticsearch");
        if (endpointGroup != null) {
            endpointGroup.close();
            EndpointGroupRegistry.unregister((String)"elasticsearch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient get() {
        if (this.result == null) {
            LazyHttpClientImpl lazyHttpClientImpl = this;
            synchronized (lazyHttpClientImpl) {
                if (this.result == null) {
                    this.result = this.factory.apply(this.getEndpoint());
                }
            }
        }
        return this.result;
    }

    Endpoint getEndpoint() {
        EndpointGroup initial = this.initialEndpoints.get();
        if (initial instanceof Endpoint) {
            return (Endpoint)initial;
        }
        EndpointGroup result = initial;
        if (this.healthCheck.isEnabled()) {
            result = this.decorateHealthCheck(initial);
        }
        boolean empty = true;
        Exception thrown = null;
        try {
            empty = result.awaitInitialEndpoints((long)this.timeoutMillis, TimeUnit.MILLISECONDS).isEmpty();
        }
        catch (Exception e) {
            thrown = e;
        }
        if (empty) {
            result.close();
            throw new IllegalStateException("couldn't connect any of " + initial.endpoints(), thrown);
        }
        EndpointGroupRegistry.register((String)"elasticsearch", (EndpointGroup)result, (EndpointSelectionStrategy)EndpointSelectionStrategy.ROUND_ROBIN);
        return Endpoint.ofGroup((String)"elasticsearch");
    }

    HealthCheckedEndpointGroup decorateHealthCheck(EndpointGroup endpointGroup) {
        HealthCheckedEndpointGroup healthChecked = HealthCheckedEndpointGroup.builder((EndpointGroup)endpointGroup, (String)"/_cluster/health").protocol(this.protocol).useGet(true).clientFactory(this.factory.delegate).withClientOptions(options -> {
            this.factory.configureOptionsExceptLogging((ClientOptionsBuilder)options);
            options.decorator(MetricCollectingClient.newDecorator((MeterIdPrefixFunction)MeterIdPrefixFunction.ofDefault((String)"elasticsearch-healthcheck")));
            options.decorator((delegate, ctx, req) -> {
                ctx.attr(HttpCall.NAME).set((Object)"health-check");
                return (HttpResponse)delegate.execute(ctx, req);
            });
            return options;
        }).retryInterval(this.healthCheck.getInterval()).build();
        healthChecked.newMeterBinder("elasticsearch").bindTo(this.meterRegistry);
        return healthChecked;
    }

    public final String toString() {
        return this.initialEndpoints.toString();
    }
}

