/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.prometheus;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ProducesJson;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.prometheus.client.CollectorRegistry;

public class ZipkinMetricsController {
    final MeterRegistry meterRegistry;
    final CollectorRegistry collectorRegistry;
    final JsonNodeFactory factory = JsonNodeFactory.instance;

    ZipkinMetricsController(MeterRegistry meterRegistry, CollectorRegistry collectorRegistry) {
        this.meterRegistry = meterRegistry;
        this.collectorRegistry = collectorRegistry;
    }

    @Get(value="/metrics")
    @ProducesJson
    public ObjectNode fetchMetricsFromMicrometer() {
        ObjectNode metricsJson = this.factory.objectNode();
        for (Meter meter : this.meterRegistry.getMeters()) {
            String transport;
            String name = meter.getId().getName();
            if (!name.startsWith("zipkin_collector") || (transport = meter.getId().getTag("transport")) == null) continue;
            Meter.Type type = meter.getId().getType();
            if (type == Meter.Type.COUNTER) {
                metricsJson.put("counter." + name + "." + transport, ((Counter)meter).count());
                continue;
            }
            if (type != Meter.Type.GAUGE) continue;
            metricsJson.put("gauge." + name + "." + transport, ((Gauge)meter).value());
        }
        return metricsJson;
    }
}

