/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.http.HttpTracing;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.brave.BraveClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SessionProtocol;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.elasticsearch.BasicAuthInterceptor;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.InitialEndpointSupplier;
import zipkin2.server.internal.elasticsearch.LazyHttpClientImpl;
import zipkin2.server.internal.elasticsearch.SslUtil;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;
import zipkin2.storage.StorageComponent;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinElasticsearchStorageConfiguration {
    static final String QUALIFIER = "zipkinElasticsearch";

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    Supplier<EndpointGroup> esInitialEndpoints(SessionProtocol esSessionProtocol, ZipkinElasticsearchStorageProperties es) {
        return new InitialEndpointSupplier(esSessionProtocol, es.getHosts());
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    SessionProtocol esSessionProtocol(ZipkinElasticsearchStorageProperties es) {
        if (es.getHosts() == null) {
            return SessionProtocol.HTTP;
        }
        if (es.getHosts().contains("https://")) {
            return SessionProtocol.HTTPS;
        }
        return SessionProtocol.HTTP;
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnMissingBean
    ClientFactory esClientFactory(ZipkinElasticsearchStorageProperties es, MeterRegistry meterRegistry) throws Exception {
        ClientFactoryBuilder builder = new ClientFactoryBuilder();
        ZipkinElasticsearchStorageProperties.Ssl ssl = es.getSsl();
        if (ssl.getKeyStore() != null || ssl.getTrustStore() != null) {
            ZipkinElasticsearchStorageConfiguration.configureSsl(builder, ssl);
        }
        return builder.useHttp2Preface(false).connectTimeoutMillis((long)es.getTimeout().intValue()).meterRegistry(meterRegistry).build();
    }

    @Bean
    HttpClientFactory esHttpClientFactory(ZipkinElasticsearchStorageProperties es, @Qualifier(value="zipkinElasticsearch") ClientFactory factory, @Qualifier(value="zipkinElasticsearch") SessionProtocol protocol, @Qualifier(value="zipkinElasticsearch") List<Consumer<ClientOptionsBuilder>> options) {
        return new HttpClientFactory(es, factory, protocol, options);
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinElasticsearchStorageProperties es, HttpClientFactory esHttpClientFactory, MeterRegistry meterRegistry, @Qualifier(value="zipkinElasticsearch") SessionProtocol protocol, @Qualifier(value="zipkinElasticsearch") Supplier<EndpointGroup> initialEndpoints, @Value(value="${zipkin.query.lookback:86400000}") int namesLookback, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        ElasticsearchStorage.Builder builder = es.toBuilder(new LazyHttpClientImpl(esHttpClientFactory, protocol, initialEndpoints, es, meterRegistry)).namesLookback(namesLookback).strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality);
        return builder.build();
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @Conditional(value={BasicAuthRequired.class})
    Consumer<ClientOptionsBuilder> esBasicAuth(final ZipkinElasticsearchStorageProperties es) {
        return new Consumer<ClientOptionsBuilder>(){

            @Override
            public void accept(ClientOptionsBuilder client) {
                client.decorator(delegate -> new BasicAuthInterceptor((Client<HttpRequest, HttpResponse>)delegate, es.getUsername(), es.getPassword()));
            }

            public String toString() {
                return "BasicAuthCustomizer{basicCredentials=<redacted>}";
            }
        };
    }

    @Bean
    @Qualifier(value="zipkinElasticsearch")
    @ConditionalOnSelfTracing
    Consumer<ClientOptionsBuilder> esTracing(Optional<HttpTracing> maybeHttpTracing) {
        if (!maybeHttpTracing.isPresent()) {
            return client -> {};
        }
        HttpTracing httpTracing = maybeHttpTracing.get().clientOf("elasticsearch");
        CurrentSpanCustomizer spanCustomizer = CurrentSpanCustomizer.create((Tracing)httpTracing.tracing());
        return arg_0 -> ZipkinElasticsearchStorageConfiguration.lambda$esTracing$2((SpanCustomizer)spanCustomizer, httpTracing, arg_0);
    }

    static ClientFactoryBuilder configureSsl(ClientFactoryBuilder builder, ZipkinElasticsearchStorageProperties.Ssl ssl) throws Exception {
        KeyManagerFactory keyManagerFactory = SslUtil.getKeyManagerFactory(ssl);
        TrustManagerFactory trustManagerFactory = SslUtil.getTrustManagerFactory(ssl);
        return builder.sslContextCustomizer(sslContextBuilder -> {
            sslContextBuilder.keyManager(keyManagerFactory);
            sslContextBuilder.trustManager(trustManagerFactory);
        });
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static /* synthetic */ void lambda$esTracing$2(SpanCustomizer spanCustomizer, HttpTracing httpTracing, ClientOptionsBuilder client) {
        client.decorator((delegate, ctx, req) -> {
            String name = (String)ctx.attr(HttpCall.NAME).get();
            if (name != null) {
                spanCustomizer.name(name);
            }
            return (HttpResponse)delegate.execute(ctx, req);
        });
        client.decorator(BraveClient.newDecorator((HttpTracing)httpTracing));
    }

    static final class BasicAuthRequired
    implements Condition {
        BasicAuthRequired() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String userName = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.username");
            String password = condition.getEnvironment().getProperty("zipkin.storage.elasticsearch.password");
            return !ZipkinElasticsearchStorageConfiguration.isEmpty(userName) && !ZipkinElasticsearchStorageConfiguration.isEmpty(password);
        }
    }
}

