/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import zipkin2.CheckResult;
import zipkin2.Component;

final class ZipkinHealthIndicator
extends CompositeHealthIndicator {
    ZipkinHealthIndicator(HealthAggregator healthAggregator) {
        super(healthAggregator);
    }

    void addComponent(Component component) {
        String healthName = component.toString();
        this.addHealthIndicator(healthName, new ComponentHealthIndicator(component));
    }

    static final class ComponentHealthIndicator
    implements HealthIndicator {
        final Component component;

        ComponentHealthIndicator(Component component) {
            this.component = component;
        }

        public synchronized Health health() {
            CheckResult result = this.component.check();
            if (result.ok()) {
                return Health.up().build();
            }
            Throwable ex = result.error();
            String message = ex.getMessage();
            return Health.down().withDetail("error", (Object)(ex.getClass().getName() + (message != null ? ": " + message : ""))).build();
        }
    }
}

