/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.grpc.protocol.AbstractUnsafeUnaryGrpcService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import zipkin2.Callback;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.storage.StorageComponent;

@ConditionalOnProperty(name={"zipkin.collector.grpc.enabled"})
final class ZipkinGrpcCollector {
    ZipkinGrpcCollector() {
    }

    @Bean
    ArmeriaServerConfigurator grpcCollectorConfigurator(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        CollectorMetrics grpcMetrics = metrics.forTransport("grpc");
        Collector collector = Collector.newBuilder(this.getClass()).storage(storage).sampler(sampler).metrics(grpcMetrics).build();
        return sb -> sb.service("/zipkin.proto3.SpanService/Report", (Service)new SpanService(collector, grpcMetrics));
    }

    static final class CompletableFutureCallback
    extends CompletableFuture<ByteBuf>
    implements Callback<Void> {
        CompletableFutureCallback() {
        }

        public void onSuccess(Void value) {
            this.complete(Unpooled.EMPTY_BUFFER);
        }

        public void onError(Throwable t) {
            this.completeExceptionally(t);
        }
    }

    static final class SpanService
    extends AbstractUnsafeUnaryGrpcService {
        final Collector collector;
        final CollectorMetrics metrics;

        SpanService(Collector collector, CollectorMetrics metrics) {
            this.collector = collector;
            this.metrics = metrics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CompletableFuture<ByteBuf> handleMessage(ByteBuf bytes) {
            this.metrics.incrementMessages();
            this.metrics.incrementBytes(bytes.readableBytes());
            if (!bytes.isReadable()) {
                return CompletableFuture.completedFuture(bytes);
            }
            try {
                CompletableFutureCallback result = new CompletableFutureCallback();
                Executor executor = (Executor)ServiceRequestContext.mapCurrent(ctx -> ctx.makeContextAware(ctx.blockingTaskExecutor()), CommonPools::blockingTaskExecutor);
                this.collector.acceptSpans(bytes.nioBuffer(), SpanBytesDecoder.PROTO3, (Callback)result, executor);
                CompletableFutureCallback completableFutureCallback = result;
                return completableFutureCallback;
            }
            finally {
                bytes.release();
            }
        }
    }
}

