/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

final class BasicAuthInterceptor
extends SimpleDecoratingClient<HttpRequest, HttpResponse> {
    final String basicCredentials;

    BasicAuthInterceptor(Client<HttpRequest, HttpResponse> client, String username, String password) {
        super(client);
        if (username == null) {
            throw new NullPointerException("username == null");
        }
        if (password == null) {
            throw new NullPointerException("password == null");
        }
        String token = username + ':' + password;
        this.basicCredentials = "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        ctx.addAdditionalRequestHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)this.basicCredentials);
        return (HttpResponse)this.delegate().execute(ctx, (Request)req);
    }
}

