/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import zipkin2.Call;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.server.internal.throttle.ActuateThrottleMetrics;
import zipkin2.server.internal.throttle.ThrottledCall;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;

public final class ThrottledStorageComponent
extends StorageComponent {
    final StorageComponent delegate;
    final AbstractLimiter<Void> limiter;
    final ThreadPoolExecutor executor;

    public ThrottledStorageComponent(StorageComponent delegate, MeterRegistry registry, int minConcurrency, int maxConcurrency, int maxQueueSize) {
        this.delegate = Objects.requireNonNull(delegate);
        Gradient2Limit limit = Gradient2Limit.newBuilder().minLimit(minConcurrency).initialLimit(minConcurrency).maxConcurrency(maxConcurrency).queueSize(0).build();
        this.limiter = ((Builder)new Builder().limit((Limit)limit)).build();
        this.executor = new ThreadPoolExecutor(limit.getLimit(), limit.getLimit(), 0L, TimeUnit.DAYS, ThrottledStorageComponent.createQueue(maxQueueSize), new ThottledThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
        limit.notifyOnChange((Consumer)new ThreadPoolExecutorResizer(this.executor));
        ActuateThrottleMetrics metrics = new ActuateThrottleMetrics(registry);
        metrics.bind(this.executor);
        metrics.bind(this.limiter);
    }

    public SpanStore spanStore() {
        return this.delegate.spanStore();
    }

    public SpanConsumer spanConsumer() {
        return new ThrottledSpanConsumer(this.delegate.spanConsumer(), (Limiter<Void>)this.limiter, this.executor);
    }

    public void close() throws IOException {
        this.executor.shutdownNow();
        this.delegate.close();
    }

    public CheckResult check() {
        return this.delegate.check();
    }

    public String toString() {
        return "Throttled(" + this.delegate.toString() + ")";
    }

    static BlockingQueue<Runnable> createQueue(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize < 0");
        }
        if (maxSize == 0) {
            maxSize = 1;
        }
        return new LinkedBlockingQueue<Runnable>(maxSize);
    }

    static final class NonLimitingLimiter
    extends AbstractLimiter<Void> {
        NonLimitingLimiter(AbstractLimiter.Builder<?> builder) {
            super(builder);
        }

        public Optional<Limiter.Listener> acquire(Void context) {
            return Optional.of(this.createListener());
        }
    }

    static final class Builder
    extends AbstractLimiter.Builder<Builder> {
        Builder() {
        }

        NonLimitingLimiter build() {
            return new NonLimitingLimiter(this);
        }

        protected Builder self() {
            return this;
        }
    }

    static final class ThreadPoolExecutorResizer
    implements Consumer<Integer> {
        final ThreadPoolExecutor executor;

        ThreadPoolExecutorResizer(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public synchronized void accept(Integer newValue) {
            int newValueInt;
            int previousValue = this.executor.getCorePoolSize();
            if (previousValue < (newValueInt = newValue.intValue())) {
                this.executor.setMaximumPoolSize(newValueInt);
                this.executor.setCorePoolSize(newValueInt);
            } else if (previousValue > newValueInt) {
                this.executor.setCorePoolSize(newValueInt);
                this.executor.setMaximumPoolSize(newValueInt);
            }
        }
    }

    static final class ThottledThreadFactory
    implements ThreadFactory {
        ThottledThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("zipkin-throttle-pool-" + thread.getId());
            return thread;
        }
    }

    static final class ThrottledSpanConsumer
    implements SpanConsumer {
        final SpanConsumer delegate;
        final Limiter<Void> limiter;
        final ExecutorService executor;

        ThrottledSpanConsumer(SpanConsumer delegate, Limiter<Void> limiter, ExecutorService executor) {
            this.delegate = delegate;
            this.limiter = limiter;
            this.executor = executor;
        }

        public Call<Void> accept(List<Span> spans) {
            return new ThrottledCall(this.executor, this.limiter, this.delegate.accept(spans));
        }

        public String toString() {
            return "Throttled(" + this.delegate + ")";
        }
    }
}

