/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.elasticsearch.ElasticsearchStorage;

@ConfigurationProperties(value="zipkin.storage.elasticsearch")
class ZipkinElasticsearchStorageProperties
implements Serializable {
    static final Logger log = Logger.getLogger(ZipkinElasticsearchStorageProperties.class.getName());
    private static final long serialVersionUID = 0L;
    private String pipeline;
    private List<String> hosts;
    private String index = "zipkin";
    private String dateSeparator = "-";
    private int maxRequests = 64;
    private Integer throttleMaxConcurrency;
    private int indexShards = 5;
    private int indexReplicas = 1;
    private String username;
    private String password;
    private HttpLoggingInterceptor.Level httpLogging;
    private int timeout = 10000;

    ZipkinElasticsearchStorageProperties(@Value(value="${zipkin.storage.throttle.enabled:false}") boolean throttleEnabled, @Value(value="${zipkin.storage.throttle.max-concurrency:200}") int throttleMaxConcurrency) {
        if (throttleEnabled) {
            this.throttleMaxConcurrency = throttleMaxConcurrency;
        }
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(String pipeline) {
        if (pipeline != null && !pipeline.isEmpty()) {
            this.pipeline = pipeline;
        }
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        if (hosts != null && !hosts.isEmpty()) {
            ArrayList<String> converted = new ArrayList<String>();
            for (String host : hosts) {
                if (host.startsWith("http://") || host.startsWith("https://")) {
                    converted.add(host);
                    continue;
                }
                int port = HttpUrl.parse((String)("http://" + host)).port();
                if (port == 80) {
                    host = host + ":9200";
                } else if (port == 9300) {
                    log.warning("Native transport no longer supported. Changing " + host + " to http port 9200");
                    host = host.replace(":9300", ":9200");
                }
                converted.add("http://" + host);
            }
            this.hosts = converted;
        }
    }

    public String getIndex() {
        return this.index;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public int getIndexShards() {
        return this.indexShards;
    }

    public void setIndexShards(int indexShards) {
        this.indexShards = indexShards;
    }

    public String getDateSeparator() {
        return this.dateSeparator;
    }

    public void setDateSeparator(String dateSeparator) {
        String trimmed = dateSeparator.trim();
        if (trimmed.length() > 1) {
            throw new IllegalArgumentException("dateSeparator must be empty or a single character");
        }
        this.dateSeparator = dateSeparator;
    }

    public int getIndexReplicas() {
        return this.indexReplicas;
    }

    public void setIndexReplicas(int indexReplicas) {
        this.indexReplicas = indexReplicas;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public HttpLoggingInterceptor.Level getHttpLogging() {
        return this.httpLogging;
    }

    public void setHttpLogging(HttpLoggingInterceptor.Level httpLogging) {
        this.httpLogging = httpLogging;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ElasticsearchStorage.Builder toBuilder(OkHttpClient client) {
        ElasticsearchStorage.Builder builder = ElasticsearchStorage.newBuilder((OkHttpClient)client);
        if (this.hosts != null) {
            builder.hosts(this.hosts);
        }
        return builder.index(this.index).dateSeparator(this.dateSeparator.isEmpty() ? (char)'\u0000' : this.dateSeparator.charAt(0)).pipeline(this.pipeline).maxRequests(this.throttleMaxConcurrency == null ? this.maxRequests : this.throttleMaxConcurrency).indexShards(this.indexShards).indexReplicas(this.indexReplicas);
    }
}

