/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.client.encoding.GzipStreamDecoderFactory;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.ReferenceCountUtil;
import zipkin2.server.internal.ZipkinHttpCollector;

final class UnzippingBytesRequestConverter {
    static final GzipStreamDecoderFactory GZIP_DECODER_FACTORY = new GzipStreamDecoderFactory();

    UnzippingBytesRequestConverter() {
    }

    static HttpData convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request) {
        ZipkinHttpCollector.metrics.incrementMessages();
        String encoding = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        HttpData content = request.content();
        if (!content.isEmpty() && encoding != null && encoding.contains("gzip") && (content = GZIP_DECODER_FACTORY.newDecoder(ctx.alloc()).decode(content)).isEmpty()) {
            ZipkinHttpCollector.maybeLog("Malformed gzip body", ctx, request);
            throw new IllegalArgumentException("Cannot gunzip spans");
        }
        if (content.isEmpty()) {
            ZipkinHttpCollector.maybeLog("Empty POST body", ctx, request);
        }
        if (content.length() == 2 && "[]".equals(content.toStringAscii())) {
            ZipkinHttpCollector.maybeLog("Empty JSON list POST body", ctx, request);
            ReferenceCountUtil.release((Object)content);
            content = HttpData.EMPTY_DATA;
        }
        ZipkinHttpCollector.metrics.incrementBytes(content.length());
        return content;
    }
}

