/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ProducesJson;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.util.LinkedHashMap;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;

public class MetricsHealthController {
    final MeterRegistry meterRegistry;
    final HealthEndpoint healthEndpoint;
    final HealthStatusHttpMapper statusMapper;
    final CollectorRegistry collectorRegistry;
    final ObjectMapper mapper;
    final JsonNodeFactory factory = JsonNodeFactory.instance;

    MetricsHealthController(MeterRegistry meterRegistry, HealthEndpoint healthEndpoint, HealthStatusHttpMapper statusMapper, CollectorRegistry collectorRegistry, ObjectMapper mapper) {
        this.meterRegistry = meterRegistry;
        this.healthEndpoint = healthEndpoint;
        this.statusMapper = statusMapper;
        this.collectorRegistry = collectorRegistry;
        this.mapper = mapper;
    }

    @Get(value="/metrics")
    @ProducesJson
    public ObjectNode fetchMetricsFromMicrometer() {
        ObjectNode metricsJson = this.factory.objectNode();
        for (Meter meter : this.meterRegistry.getMeters()) {
            String transport;
            String name = meter.getId().getName();
            if (!name.startsWith("zipkin_collector") || (transport = meter.getId().getTag("transport")) == null) continue;
            switch (meter.getId().getType()) {
                case COUNTER: {
                    metricsJson.put("counter." + name + "." + transport, ((Counter)meter).count());
                    break;
                }
                case GAUGE: {
                    metricsJson.put("gauge." + name + "." + transport, ((Gauge)meter).value());
                }
            }
        }
        return metricsJson;
    }

    @Get(value="/health")
    public HttpResponse getHealth() throws JsonProcessingException {
        Health health = this.healthEndpoint.health();
        LinkedHashMap<String, String> healthJson = new LinkedHashMap<String, String>();
        healthJson.put("status", health.getStatus().getCode());
        healthJson.put("zipkin", (String)health.getDetails().get("zipkin"));
        byte[] body = this.mapper.writer().writeValueAsBytes(healthJson);
        ResponseHeaders headers = ResponseHeaders.builder((int)this.statusMapper.mapStatus(health.getStatus())).contentType(MediaType.JSON).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, body.length).build();
        return HttpResponse.of((ResponseHeaders)headers, (HttpData)HttpData.of((byte[])body));
    }
}

