/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.ui;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import zipkin.autoconfigure.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
@RestController
public class ZipkinUiAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource indexHtml;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/zipkin/**"}).addResourceLocations(new String[]{"classpath:/zipkin-ui/"}).setCachePeriod(Integer.valueOf((int)TimeUnit.DAYS.toSeconds(365L)));
    }

    @Bean
    @Order(value=-2147483648)
    public CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter filter = new CharacterEncodingFilter(){

            protected boolean shouldNotFilter(HttpServletRequest request) {
                return request.getServletPath().endsWith(".png");
            }
        };
        filter.setEncoding("UTF-8");
        filter.setForceEncoding(true);
        return filter;
    }

    @RequestMapping(value={"/zipkin/config.json"}, method={RequestMethod.GET})
    public ResponseEntity<ZipkinUiProperties> serveUiConfig() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.APPLICATION_JSON).body((Object)this.ui);
    }

    @RequestMapping(value={"/zipkin/index.html"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> serveIndex() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).body((Object)this.indexHtml);
    }

    @RequestMapping(value={"/zipkin/", "/zipkin/traces/{id}", "/zipkin/dependency"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/zipkin/index.html");
    }

    @RequestMapping(value={"/zipkin/api/**"}, method={RequestMethod.GET})
    public ModelAndView forwardApi(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return new ModelAndView("forward:" + path.replaceFirst("/zipkin", ""));
    }

    @RequestMapping(value={"/favicon.ico"}, method={RequestMethod.GET})
    public ModelAndView favicon() {
        return new ModelAndView("forward:/zipkin/favicon.ico");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void redirectRoot(HttpServletResponse response) throws IOException {
        response.setHeader("Location", "./zipkin/");
        response.setStatus(HttpStatus.FOUND.value());
    }
}

