/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.autoconfigure.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RedirectService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.HttpFileService;
import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import zipkin2.autoconfigure.ui.AddHttpHeadersService;
import zipkin2.autoconfigure.ui.ZipkinUiProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinUiProperties.class})
@ConditionalOnProperty(name={"zipkin.ui.enabled"}, matchIfMissing=true)
class ZipkinUiAutoConfiguration {
    static final HttpHeaders CACHE_YEAR = HttpHeaders.of((AsciiString)HttpHeaderNames.CACHE_CONTROL, (String)("max-age=" + TimeUnit.DAYS.toSeconds(365L)));
    static final HttpHeaders CONFIG_HEADERS = (HttpHeaders)((HttpHeaders)HttpHeaders.of((HttpStatus)HttpStatus.OK).add((Headers)HttpHeaders.of((AsciiString)HttpHeaderNames.CONTENT_TYPE, (String)"application/json"))).add((Headers)HttpHeaders.of((AsciiString)HttpHeaderNames.CACHE_CONTROL, (String)("max-age=" + TimeUnit.MINUTES.toSeconds(10L))));
    static final HttpHeaders INDEX_HEADERS = (HttpHeaders)((HttpHeaders)HttpHeaders.of((HttpStatus)HttpStatus.OK).add((Headers)HttpHeaders.of((AsciiString)HttpHeaderNames.CONTENT_TYPE, (String)"text/html"))).add((Headers)HttpHeaders.of((AsciiString)HttpHeaderNames.CACHE_CONTROL, (String)("max-age=" + TimeUnit.MINUTES.toSeconds(1L))));
    @Autowired
    ZipkinUiProperties ui;
    @Value(value="classpath:zipkin-ui/index.html")
    Resource indexHtml;
    @Value(value="classpath:zipkin-lens/index.html")
    Resource lensIndexHtml;

    ZipkinUiAutoConfiguration() {
    }

    @Bean
    @Lazy
    String processedIndexHtml() {
        return this.processedIndexHtml(this.indexHtml);
    }

    @Bean
    @Lazy
    String processedLensIndexHtml() {
        return this.processedIndexHtml(this.lensIndexHtml);
    }

    String processedIndexHtml(Resource indexHtml) {
        Document soup;
        String baseTagValue = "/".equals(this.ui.getBasepath()) ? "/" : this.ui.getBasepath() + "/";
        try (InputStream is = indexHtml.getInputStream();){
            soup = Jsoup.parse((InputStream)is, null, (String)baseTagValue);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (soup.head().getElementsByTag("base").isEmpty()) {
            soup.head().appendChild((Node)soup.createElement("base"));
        }
        soup.head().getElementsByTag("base").attr("href", baseTagValue);
        return soup.html();
    }

    @Bean
    @Lazy
    IndexSwitchingService indexSwitchingService() {
        HttpFileBuilder lensIndex;
        HttpFileBuilder legacyIndex;
        if ("/zipkin".equals(this.ui.getBasepath())) {
            legacyIndex = HttpFileBuilder.ofResource((String)"zipkin-ui/index.html");
            lensIndex = HttpFileBuilder.ofResource((String)"zipkin-lens/index.html");
        } else {
            legacyIndex = HttpFileBuilder.of((HttpData)HttpData.of((byte[])this.processedIndexHtml().getBytes(StandardCharsets.UTF_8)));
            lensIndex = HttpFileBuilder.of((HttpData)HttpData.of((byte[])this.processedLensIndexHtml().getBytes(StandardCharsets.UTF_8)));
        }
        legacyIndex.setHeaders((Headers)INDEX_HEADERS);
        lensIndex.setHeaders((Headers)INDEX_HEADERS);
        return new IndexSwitchingService(legacyIndex.build().asService(), lensIndex.build().asService());
    }

    @Bean
    @Lazy
    ArmeriaServerConfigurator uiServerConfigurator(IndexSwitchingService indexSwitchingService) throws IOException {
        AddHttpHeadersService uiFileService = new AddHttpHeadersService((Service<HttpRequest, HttpResponse>)HttpFileService.forClassPath((String)"zipkin-ui").orElse((Service)HttpFileService.forClassPath((String)"zipkin-lens")), CACHE_YEAR);
        byte[] config = new ObjectMapper().writeValueAsBytes((Object)this.ui);
        return arg_0 -> ZipkinUiAutoConfiguration.lambda$uiServerConfigurator$0(config, indexSwitchingService, (Service)uiFileService, arg_0);
    }

    private static /* synthetic */ void lambda$uiServerConfigurator$0(byte[] config, IndexSwitchingService indexSwitchingService, Service uiFileService, ServerBuilder sb) {
        sb.service("/zipkin/config.json", (Service)((HttpFileBuilder)HttpFileBuilder.of((HttpData)HttpData.of((byte[])config)).addHeaders((Headers)CONFIG_HEADERS)).build().asService()).service("/zipkin/index.html", (Service)indexSwitchingService).service("/zipkin/", (Service)indexSwitchingService).service("/zipkin/traces/{id}", (Service)indexSwitchingService).service("/zipkin/dependency", (Service)indexSwitchingService).service("/zipkin/traceViewer", (Service)indexSwitchingService).serviceUnder("/zipkin/", uiFileService).service("/favicon.ico", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/favicon.ico")).service("/", (Service)new RedirectService(HttpStatus.FOUND, "/zipkin/"));
    }

    static class IndexSwitchingService
    extends AbstractHttpService {
        final HttpService legacyIndex;
        final HttpService lensIndex;

        IndexSwitchingService(HttpService legacyIndex, HttpService lensIndex) {
            this.legacyIndex = legacyIndex;
            this.lensIndex = lensIndex;
        }

        public HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            Set cookies = ServerCookieDecoder.LAX.decode((String)req.headers().get((Object)HttpHeaderNames.COOKIE, (Object)""));
            for (Cookie cookie : cookies) {
                if (!cookie.name().equals("lens") || !Boolean.parseBoolean(cookie.value())) continue;
                return this.lensIndex.serve(ctx, req);
            }
            return this.legacyIndex.serve(ctx, req);
        }
    }
}

