/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.throttle;

import com.linecorp.armeria.common.metric.NoopMeterRegistry;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limit.FixedLimit;
import com.netflix.concurrency.limits.limiter.SimpleLimiter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.server.internal.throttle.LimiterMetrics;
import zipkin2.server.internal.throttle.ThrottledCall;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=2)
public class ThrottledCallBenchmarks {
    ExecutorService fakeCallExecutor = Executors.newSingleThreadExecutor();
    ExecutorService executor = Executors.newSingleThreadExecutor();
    ThrottledCall call;
    static final RejectedExecutionException OVER_CAPACITY = new RejectedExecutionException();

    @Setup
    public void setup() {
        this.executor = Executors.newSingleThreadExecutor();
        this.fakeCallExecutor = Executors.newSingleThreadExecutor();
        SimpleLimiter limiter = ((SimpleLimiter.Builder)SimpleLimiter.newBuilder().limit((Limit)FixedLimit.of((int)1))).build();
        LimiterMetrics metrics = new LimiterMetrics((MeterRegistry)NoopMeterRegistry.get());
        Predicate<Throwable> isOverCapacity = RejectedExecutionException.class::isInstance;
        this.call = new ThrottledCall((Call)new FakeCall(this.fakeCallExecutor), (Executor)this.executor, (Limiter)limiter, metrics, isOverCapacity);
    }

    @TearDown
    public void tearDown() {
        this.executor.shutdown();
        this.fakeCallExecutor.shutdown();
    }

    @Benchmark
    public Object execute() throws IOException {
        return this.call.clone().execute();
    }

    @Benchmark
    public void execute_overCapacity() throws IOException {
        block2: {
            ThrottledCall overCapacity = (ThrottledCall)this.call.clone();
            ((FakeCall)overCapacity.delegate).overCapacity = true;
            try {
                overCapacity.execute();
            }
            catch (RejectedExecutionException e) {
                if ($assertionsDisabled || e == OVER_CAPACITY) break block2;
                throw new AssertionError();
            }
        }
    }

    @Benchmark
    public void execute_throttled() throws IOException {
        this.call.limiter.acquire(null);
        this.call.clone().execute();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().addProfiler("gc").include(".*" + ThrottledCallBenchmarks.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    static final class FakeCall
    extends Call.Base<Void> {
        final Executor executor;
        boolean overCapacity = false;

        FakeCall(Executor executor) {
            this.executor = executor;
        }

        public Void doExecute() throws IOException {
            if (this.overCapacity) {
                throw OVER_CAPACITY;
            }
            return null;
        }

        public void doEnqueue(Callback<Void> callback) {
            this.executor.execute(() -> {
                if (this.overCapacity) {
                    callback.onError((Throwable)OVER_CAPACITY);
                } else {
                    callback.onSuccess(null);
                }
            });
        }

        public FakeCall clone() {
            return new FakeCall(this.executor);
        }
    }
}

