/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.internal.DelayLimiter;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=2)
public class DelayLimiterBenchmarks {
    final Random rng = new Random();
    final DelayLimiter<Long> limiter = DelayLimiter.newBuilder().ttl(1L, TimeUnit.HOURS).cardinality(20000).build();

    @Benchmark
    public boolean shouldInvoke_randomData() {
        return this.limiter.shouldInvoke((Object)this.rng.nextLong());
    }

    @Benchmark
    public boolean shouldInvoke_sameData() {
        return this.limiter.shouldInvoke((Object)1L);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().addProfiler("gc").include(".*" + DelayLimiterBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

