/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch.internal;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.RequestHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.BulkCallBuilder;
import zipkin2.elasticsearch.internal.BulkIndexWriter;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.storage.cassandra.internal.Resources;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=2)
public class BulkRequestBenchmarks {
    static final Span CLIENT_SPAN = (Span)SpanBytesDecoder.JSON_V2.decodeOne(Resources.resourceToString((String)"/zipkin2-client.json").getBytes(StandardCharsets.UTF_8));
    final ElasticsearchStorage es = ElasticsearchStorage.newBuilder(() -> null).build();
    final long indexTimestamp = CLIENT_SPAN.timestampAsLong() / 1000L;
    final String spanIndex = this.es.indexNameFormatter().formatTypeAndTimestampForInsert("span", '-', this.indexTimestamp);
    final BulkCallBuilder.IndexEntry<Span> entry = BulkCallBuilder.newIndexEntry((String)this.spanIndex, (String)"span", (Object)CLIENT_SPAN, (BulkIndexWriter)BulkIndexWriter.SPAN);

    @Benchmark
    public ByteBuf writeRequest_singleSpan() {
        return BulkCallBuilder.serialize((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, this.entry, (boolean)true);
    }

    @Benchmark
    public HttpRequest buildAndWriteRequest_singleSpan() {
        BulkCallBuilder builder = new BulkCallBuilder(this.es, 6.7f, "index-span");
        builder.index(this.spanIndex, "span", (Object)CLIENT_SPAN, BulkIndexWriter.SPAN);
        HttpCall.RequestSupplier supplier = builder.build().request;
        HttpRequestWriter request = HttpRequest.streaming((RequestHeaders)supplier.headers());
        supplier.writeBody(arg_0 -> ((HttpRequestWriter)request).tryWrite(arg_0));
        return request;
    }

    @Benchmark
    public HttpRequest buildAndWriteRequest_tenSpans() {
        BulkCallBuilder builder = new BulkCallBuilder(this.es, 6.7f, "index-span");
        for (int i = 0; i < 10; ++i) {
            builder.index(this.spanIndex, "span", (Object)CLIENT_SPAN, BulkIndexWriter.SPAN);
        }
        HttpCall.RequestSupplier supplier = builder.build().request;
        HttpRequestWriter request = HttpRequest.streaming((RequestHeaders)supplier.headers());
        supplier.writeBody(arg_0 -> ((HttpRequestWriter)request).tryWrite(arg_0));
        return request;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().addProfiler("gc").include(".*" + BulkRequestBenchmarks.class.getSimpleName() + ".*").build();
        new Runner(opt).run();
    }
}

