/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.RecyclableBuffers;

public class WireSpanDecoder {
    static final Logger LOG = Logger.getLogger(WireSpanDecoder.class.getName());
    static final boolean DEBUG = false;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static boolean decodeTag(ProtoReader input, Span.Builder span) throws IOException {
        String key = null;
        String value = "";
        boolean done = false;
        block5: while (!done) {
            int tag = input.nextTag();
            switch (tag) {
                case -1: {
                    done = true;
                    continue block5;
                }
                case 1: {
                    key = input.readString();
                    continue block5;
                }
                case 2: {
                    value = input.readString();
                    continue block5;
                }
            }
            WireSpanDecoder.logAndSkip(input, tag);
        }
        if (key == null) {
            return false;
        }
        span.putTag(key, value);
        return true;
    }

    static boolean decodeAnnotation(ProtoReader input, Span.Builder span) throws IOException {
        long timestamp = 0L;
        String value = null;
        boolean done = false;
        block5: while (!done) {
            int tag = input.nextTag();
            switch (tag) {
                case -1: {
                    done = true;
                    continue block5;
                }
                case 1: {
                    timestamp = input.readFixed64();
                    continue block5;
                }
                case 2: {
                    value = input.readString();
                    continue block5;
                }
            }
            WireSpanDecoder.logAndSkip(input, tag);
        }
        if (timestamp == 0L || value == null) {
            return false;
        }
        span.addAnnotation(timestamp, value);
        return true;
    }

    private static Endpoint decodeEndpoint(ProtoReader input) throws IOException {
        Endpoint.Builder endpoint = Endpoint.newBuilder();
        boolean done = false;
        block6: while (!done) {
            int tag = input.nextTag();
            switch (tag) {
                case -1: {
                    done = true;
                    continue block6;
                }
                case 1: {
                    String s = input.readString();
                    endpoint.serviceName(s);
                    continue block6;
                }
                case 2: 
                case 3: {
                    endpoint.parseIp(input.readBytes().toByteArray());
                    continue block6;
                }
                case 4: {
                    endpoint.port(input.readVarint32());
                    continue block6;
                }
            }
            WireSpanDecoder.logAndSkip(input, tag);
        }
        return endpoint.build();
    }

    public static Span decodeOne(ProtoReader input) throws IOException {
        Span.Builder span = Span.newBuilder();
        boolean done = false;
        while (!done) {
            int tag = input.nextTag();
            switch (tag) {
                case -1: {
                    done = true;
                    break;
                }
                case 1: {
                    span.traceId(WireSpanDecoder.readHexString(input));
                    break;
                }
                case 2: {
                    span.parentId(WireSpanDecoder.readHexString(input));
                    break;
                }
                case 3: {
                    span.id(WireSpanDecoder.readHexString(input));
                    break;
                }
                case 4: {
                    int kind = input.readVarint32();
                    if (kind == 0 || kind > Span.Kind.values().length) break;
                    span.kind(Span.Kind.values()[kind - 1]);
                    break;
                }
                case 5: {
                    String name = input.readString();
                    span.name(name);
                    break;
                }
                case 6: {
                    span.timestamp(input.readFixed64());
                    break;
                }
                case 7: {
                    span.duration(input.readVarint64());
                    break;
                }
                case 8: {
                    long token = input.beginMessage();
                    span.localEndpoint(WireSpanDecoder.decodeEndpoint(input));
                    input.endMessageAndGetUnknownFields(token);
                    break;
                }
                case 9: {
                    long token = input.beginMessage();
                    span.remoteEndpoint(WireSpanDecoder.decodeEndpoint(input));
                    input.endMessageAndGetUnknownFields(token);
                    break;
                }
                case 10: {
                    long token = input.beginMessage();
                    WireSpanDecoder.decodeAnnotation(input, span);
                    input.endMessageAndGetUnknownFields(token);
                    break;
                }
                case 11: {
                    long token = input.beginMessage();
                    WireSpanDecoder.decodeTag(input, span);
                    input.endMessageAndGetUnknownFields(token);
                    break;
                }
                case 12: {
                    span.debug((Boolean)ProtoAdapter.BOOL.decode(input));
                    break;
                }
                case 13: {
                    span.shared((Boolean)ProtoAdapter.BOOL.decode(input));
                    break;
                }
                default: {
                    WireSpanDecoder.logAndSkip(input, tag);
                }
            }
        }
        return span.build();
    }

    public static List<Span> decodeList(byte[] spans) {
        return WireSpanDecoder.decodeList(new ProtoReader((BufferedSource)new Buffer().write(spans)));
    }

    public static List<Span> decodeList(ByteBuffer spans) {
        Buffer buffer = new Buffer();
        try {
            buffer.write(spans);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return WireSpanDecoder.decodeList(new ProtoReader((BufferedSource)buffer));
    }

    public static List<Span> decodeList(ProtoReader input) {
        long token;
        ArrayList<Span> spans = new ArrayList<Span>();
        try {
            token = input.beginMessage();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            boolean done = false;
            block10: while (!done) {
                int tag = input.nextTag();
                switch (tag) {
                    case -1: {
                        done = true;
                        continue block10;
                    }
                    case 1: {
                        long subToken = input.beginMessage();
                        spans.add(WireSpanDecoder.decodeOne(input));
                        input.endMessageAndGetUnknownFields(subToken);
                        continue block10;
                    }
                }
                WireSpanDecoder.logAndSkip(input, tag);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            input.endMessageAndGetUnknownFields(token);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return spans;
    }

    private static String readHexString(ProtoReader input) throws IOException {
        ByteString bytes = input.readBytes();
        int length = bytes.size() * 2;
        if (length > 32) {
            throw new AssertionError((Object)("hex field greater than 32 chars long: " + length));
        }
        char[] result = RecyclableBuffers.shortStringBuffer();
        for (int i = 0; i < bytes.size(); ++i) {
            byte b = bytes.getByte(i);
            result[2 * i] = HEX_DIGITS[b >> 4 & 0xF];
            result[2 * i + 1] = HEX_DIGITS[b & 0xF];
        }
        return new String(result, 0, length);
    }

    static void logAndSkip(ProtoReader input, int tag) throws IOException {
        input.skip();
    }
}

