/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Span;
import zipkin2.codec.ProtobufSpanDecoder;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.codec.WireSpanDecoder;
import zipkin2.storage.cassandra.internal.Resources;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
public class ProtoCodecBenchmarks {
    static final byte[] clientSpanJsonV2 = Resources.resourceToString((String)"/zipkin2-client.json").getBytes(StandardCharsets.UTF_8);
    static final Span clientSpan = (Span)SpanBytesDecoder.JSON_V2.decodeOne(clientSpanJsonV2);
    static final List<Span> spans = Collections.nCopies(1000, clientSpan);
    static final byte[] encodedBytes = SpanBytesEncoder.PROTO3.encodeList(spans);
    private ByteBuf encodedBuf;

    @Setup
    public void setup() {
        this.encodedBuf = PooledByteBufAllocator.DEFAULT.buffer(encodedBytes.length);
        this.encodedBuf.writeBytes(encodedBytes);
    }

    @TearDown
    public void tearDown() {
        this.encodedBuf.release();
    }

    @Benchmark
    public List<Span> bytes_zipkinDecoder() {
        return SpanBytesDecoder.PROTO3.decodeList(encodedBytes);
    }

    @Benchmark
    public List<Span> bytes_protobufDecoder() {
        return ProtobufSpanDecoder.decodeList(encodedBytes);
    }

    @Benchmark
    public List<Span> bytes_wireDecoder() {
        return WireSpanDecoder.decodeList(encodedBytes);
    }

    @Benchmark
    public List<Span> bytebuffer_zipkinDecoder() {
        return SpanBytesDecoder.PROTO3.decodeList(this.encodedBuf.nioBuffer());
    }

    @Benchmark
    public List<Span> bytebuffer_protobufDecoder() {
        return ProtobufSpanDecoder.decodeList(this.encodedBuf.nioBuffer());
    }

    @Benchmark
    public List<Span> bytebuffer_wireDecoder() {
        return WireSpanDecoder.decodeList(this.encodedBuf.nioBuffer());
    }

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(".*" + ProtoCodecBenchmarks.class.getSimpleName()).addProfiler("gc").build();
        new Runner(opt).run();
    }
}

