/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import okio.Timeout;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.Nullable;

public final class MoshiSpanDecoder {
    final JsonAdapter<List<Span>> listSpansAdapter = new Moshi.Builder().add(Span.class, SPAN_ADAPTER).build().adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Span.class}));
    public static final JsonAdapter<Span> SPAN_ADAPTER = new JsonAdapter<Span>(){

        public Span fromJson(JsonReader reader) throws IOException {
            Span.Builder result = Span.newBuilder();
            reader.beginObject();
            block30: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "traceId": {
                        result.traceId(reader.nextString());
                        continue block30;
                    }
                    case "parentId": {
                        result.parentId(reader.nextString());
                        continue block30;
                    }
                    case "id": {
                        result.id(reader.nextString());
                        continue block30;
                    }
                    case "kind": {
                        result.kind(Span.Kind.valueOf((String)reader.nextString()));
                        continue block30;
                    }
                    case "name": {
                        result.name(reader.nextString());
                        continue block30;
                    }
                    case "timestamp": {
                        result.timestamp(reader.nextLong());
                        continue block30;
                    }
                    case "duration": {
                        result.duration(reader.nextLong());
                        continue block30;
                    }
                    case "localEndpoint": {
                        result.localEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "remoteEndpoint": {
                        result.remoteEndpoint((Endpoint)ENDPOINT_ADAPTER.fromJson(reader));
                        continue block30;
                    }
                    case "annotations": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Annotation a = (Annotation)ANNOTATION_ADAPTER.fromJson(reader);
                            result.addAnnotation(a.timestamp(), a.value());
                        }
                        reader.endArray();
                        continue block30;
                    }
                    case "tags": {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            result.putTag(reader.nextName(), reader.nextString());
                        }
                        reader.endObject();
                        continue block30;
                    }
                    case "debug": {
                        result.debug(reader.nextBoolean());
                        continue block30;
                    }
                    case "shared": {
                        result.shared(reader.nextBoolean());
                        continue block30;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public void toJson(JsonWriter writer, @Nullable Span value) {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Annotation> ANNOTATION_ADAPTER = new JsonAdapter<Annotation>(){

        public Annotation fromJson(JsonReader reader) throws IOException {
            reader.beginObject();
            Long timestamp = null;
            String value = null;
            block8: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "timestamp": {
                        timestamp = reader.nextLong();
                        continue block8;
                    }
                    case "value": {
                        value = reader.nextString();
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (timestamp == null || value == null) {
                throw new IllegalStateException("Incomplete annotation at " + reader.getPath());
            }
            return Annotation.create((long)timestamp, value);
        }

        public void toJson(JsonWriter writer, @Nullable Annotation value) {
            throw new UnsupportedOperationException();
        }
    };
    static final JsonAdapter<Endpoint> ENDPOINT_ADAPTER = new JsonAdapter<Endpoint>(){

        public Endpoint fromJson(JsonReader reader) throws IOException {
            reader.beginObject();
            String serviceName = null;
            String ipv4 = null;
            String ipv6 = null;
            int port = 0;
            block12: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (reader.peek() == JsonReader.Token.NULL) {
                    reader.skipValue();
                    continue;
                }
                switch (nextName) {
                    case "serviceName": {
                        serviceName = reader.nextString();
                        continue block12;
                    }
                    case "ipv4": {
                        ipv4 = reader.nextString();
                        continue block12;
                    }
                    case "ipv6": {
                        ipv6 = reader.nextString();
                        continue block12;
                    }
                    case "port": {
                        port = reader.nextInt();
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (serviceName == null && ipv4 == null && ipv6 == null && port == 0) {
                return null;
            }
            return Endpoint.newBuilder().serviceName(serviceName).ip(ipv4).ip(ipv6).port(port).build();
        }

        public void toJson(JsonWriter writer, @Nullable Endpoint value) {
            throw new UnsupportedOperationException();
        }
    }.nullSafe();

    public static MoshiSpanDecoder create() {
        return new MoshiSpanDecoder();
    }

    MoshiSpanDecoder() {
    }

    public List<Span> decodeList(byte[] spans) {
        Buffer source = new Buffer().write(spans);
        try {
            return (List)this.listSpansAdapter.fromJson((BufferedSource)source);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Span> decodeList(ByteBuffer spans) {
        try {
            return (List)this.listSpansAdapter.fromJson(JsonReader.of((BufferedSource)Okio.buffer((Source)new ByteBufferSource(spans))));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    final class ByteBufferSource
    implements Source {
        final ByteBuffer source;
        final Buffer.UnsafeCursor cursor = new Buffer.UnsafeCursor();

        ByteBufferSource(ByteBuffer source) {
            this.source = source;
        }

        public long read(Buffer sink, long byteCount) {
            try (Buffer.UnsafeCursor ignored = sink.readAndWriteUnsafe(this.cursor);){
                long oldSize = sink.size();
                int length = (int)Math.min((long)this.source.remaining(), Math.min(8192L, byteCount));
                if (length == 0) {
                    long l = -1L;
                    return l;
                }
                this.cursor.expandBuffer(length);
                this.source.get(this.cursor.data, this.cursor.start, length);
                this.cursor.resizeBuffer(oldSize + (long)length);
                long l = length;
                return l;
            }
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() {
        }
    }
}

