/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.storage.cassandra.internal.Resources;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=1)
public class CodecBenchmarks {
    static final byte[] clientSpanJsonV2 = Resources.resourceToString((String)"/zipkin2-client.json").getBytes(StandardCharsets.UTF_8);
    static final Span clientSpan = (Span)SpanBytesDecoder.JSON_V2.decodeOne(clientSpanJsonV2);
    static final byte[] clientSpanJsonV1 = SpanBytesEncoder.JSON_V1.encode((Object)clientSpan);
    static final byte[] clientSpanProto3 = SpanBytesEncoder.PROTO3.encode((Object)clientSpan);
    static final byte[] clientSpanThrift = SpanBytesEncoder.THRIFT.encode((Object)clientSpan);
    static final List<Span> tenClientSpans = Collections.nCopies(10, clientSpan);
    static final byte[] tenClientSpansJsonV2 = SpanBytesEncoder.JSON_V2.encodeList(tenClientSpans);
    static final byte[] chineseSpanJsonV2 = Resources.resourceToString((String)"/zipkin2-chinese.json").getBytes(StandardCharsets.UTF_8);
    static final Span chineseSpan = (Span)SpanBytesDecoder.JSON_V2.decodeOne(chineseSpanJsonV2);
    static final byte[] chineseSpanProto3 = SpanBytesEncoder.PROTO3.encode((Object)chineseSpan);
    static final byte[] chineseSpanJsonV1 = SpanBytesEncoder.JSON_V1.encode((Object)chineseSpan);
    static final byte[] chineseSpanThrift = SpanBytesEncoder.THRIFT.encode((Object)chineseSpan);

    @Benchmark
    public Span readClientSpan_JSON_V1() {
        return (Span)SpanBytesDecoder.JSON_V1.decodeOne(clientSpanJsonV1);
    }

    @Benchmark
    public Span readClientSpan_JSON_V2() {
        return (Span)SpanBytesDecoder.JSON_V2.decodeOne(clientSpanJsonV2);
    }

    @Benchmark
    public Span readClientSpan_PROTO3() {
        return (Span)SpanBytesDecoder.PROTO3.decodeOne(clientSpanProto3);
    }

    @Benchmark
    public Span readClientSpan_THRIFT() {
        return (Span)SpanBytesDecoder.THRIFT.decodeOne(clientSpanThrift);
    }

    @Benchmark
    public byte[] writeClientSpan_JSON_V2() {
        return SpanBytesEncoder.JSON_V2.encode((Object)clientSpan);
    }

    @Benchmark
    public byte[] writeClientSpan_JSON_V1() {
        return SpanBytesEncoder.JSON_V1.encode((Object)clientSpan);
    }

    @Benchmark
    public byte[] writeClientSpan_PROTO3() {
        return SpanBytesEncoder.PROTO3.encode((Object)clientSpan);
    }

    @Benchmark
    public byte[] writeClientSpan_THRIFT() {
        return SpanBytesEncoder.THRIFT.encode((Object)clientSpan);
    }

    @Benchmark
    public List<Span> readTenClientSpans_JSON_V2() {
        return SpanBytesDecoder.JSON_V2.decodeList(tenClientSpansJsonV2);
    }

    @Benchmark
    public byte[] writeTenClientSpans_JSON_V2() {
        return SpanBytesEncoder.JSON_V2.encodeList(tenClientSpans);
    }

    @Benchmark
    public Span readChineseSpan_JSON_V1() {
        return (Span)SpanBytesDecoder.JSON_V1.decodeOne(chineseSpanJsonV1);
    }

    @Benchmark
    public Span readChineseSpan_JSON_V2() {
        return (Span)SpanBytesDecoder.JSON_V2.decodeOne(chineseSpanJsonV2);
    }

    @Benchmark
    public Span readChineseSpan_PROTO3() {
        return (Span)SpanBytesDecoder.PROTO3.decodeOne(chineseSpanProto3);
    }

    @Benchmark
    public Span readChineseSpan_THRIFT() {
        return (Span)SpanBytesDecoder.THRIFT.decodeOne(chineseSpanThrift);
    }

    @Benchmark
    public byte[] writeChineseSpan_JSON_V2() {
        return SpanBytesEncoder.JSON_V2.encode((Object)chineseSpan);
    }

    @Benchmark
    public byte[] writeChineseSpan_JSON_V1() {
        return SpanBytesEncoder.JSON_V1.encode((Object)chineseSpan);
    }

    @Benchmark
    public byte[] writeChineseSpan_PROTO3() {
        return SpanBytesEncoder.PROTO3.encode((Object)chineseSpan);
    }

    @Benchmark
    public byte[] writeChineseSpan_THRIFT() {
        return SpanBytesEncoder.THRIFT.encode((Object)chineseSpan);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + CodecBenchmarks.class.getSimpleName() + ".*read.*Span_.*").addProfiler("gc").build();
        new Runner(opt).run();
    }
}

