/*
 * Decompiled with CFR 0.152.
 */
package zipkin2;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.HexCodec;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.SampleTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Thread)
@Threads(value=2)
public class SpanBenchmarks {
    static final Endpoint FRONTEND = Endpoint.newBuilder().serviceName("frontend").ip("127.0.0.1").build();
    static final Endpoint BACKEND = Endpoint.newBuilder().serviceName("backend").ip("192.168.99.101").port(9000).build();
    static final Span clientSpan = SpanBenchmarks.buildClientSpan(Span.newBuilder());
    final Span.Builder sharedBuilder = this.buildClientSpan().toBuilder();
    static final String traceIdHex = "86154a4ba6e91385";
    static final String spanIdHex = "4d1e00c0db9010db";
    static final long traceId = HexCodec.lowerHexToUnsignedLong((String)"86154a4ba6e91385");
    static final long spanId = HexCodec.lowerHexToUnsignedLong((String)"4d1e00c0db9010db");
    static final Kryo kryo = new Kryo();
    static final byte[] clientSpanSerialized;

    @Benchmark
    public Span buildClientSpan() {
        return SpanBenchmarks.buildClientSpan(Span.newBuilder());
    }

    @Benchmark
    public Span buildClientSpan_longs() {
        return SpanBenchmarks.buildClientSpan_longs(Span.newBuilder());
    }

    static Span buildClientSpan(Span.Builder builder) {
        return builder.traceId(traceIdHex).parentId(traceIdHex).id(spanIdHex).name("get").kind(Span.Kind.CLIENT).localEndpoint(FRONTEND).remoteEndpoint(BACKEND).timestamp(1472470996199000L).duration(207000L).addAnnotation(1472470996238000L, "ws").addAnnotation(1472470996403000L, "wr").putTag("http.path", "/api").putTag("clnt/finagle.version", "6.45.0").build();
    }

    static Span buildClientSpan_longs(Span.Builder builder) {
        return builder.traceId(0L, traceId).parentId(traceId).id(spanId).name("get").kind(Span.Kind.CLIENT).localEndpoint(FRONTEND).remoteEndpoint(BACKEND).timestamp(1472470996199000L).duration(207000L).addAnnotation(1472470996238000L, "ws").addAnnotation(1472470996403000L, "wr").putTag("http.path", "/api").putTag("clnt/finagle.version", "6.45.0").build();
    }

    @Benchmark
    public Span buildClientSpan_clear() {
        return SpanBenchmarks.buildClientSpan(this.sharedBuilder.clear());
    }

    @Benchmark
    public Span buildClientSpan_clone() {
        return this.sharedBuilder.clone().build();
    }

    @Benchmark
    public Span serialize_kryo() {
        return (Span)kryo.readObject(new Input(clientSpanSerialized), Span.class);
    }

    @Benchmark
    public byte[] deserialize_kryo() {
        Output output = new Output(clientSpanSerialized.length);
        kryo.writeObject(output, (Object)clientSpan);
        output.flush();
        return output.getBuffer();
    }

    @Benchmark
    public String padLeft_1Char() {
        return Span.padLeft((String)"1", (int)16);
    }

    @Benchmark
    public String padLeft_15Chars() {
        return Span.padLeft((String)"123456789012345", (int)16);
    }

    @Benchmark
    public String padLeft_17Chars() {
        return Span.padLeft((String)"12345678901234567", (int)32);
    }

    @Benchmark
    public String padLeft_31Chars() {
        return Span.padLeft((String)"1234567890123456789012345678901", (int)32);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(".*" + SpanBenchmarks.class.getSimpleName() + ".*").addProfiler("gc").build();
        new Runner(opt).run();
    }

    static {
        kryo.register(Span.class, (Serializer)new JavaSerializer());
        Output output = new Output(4096);
        kryo.writeObject(output, (Object)clientSpan);
        output.flush();
        clientSpanSerialized = output.getBuffer();
    }
}

