/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.sqs;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.module.aws.sqs.ZipkinSQSCollectorProperties;
import zipkin.module.aws.sqs.ZipkinSQSCredentialsConfiguration;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.sqs.SQSCollector;
import zipkin2.storage.StorageComponent;

@Configuration
@EnableConfigurationProperties(value={ZipkinSQSCollectorProperties.class})
@Conditional(value={SQSSetCondition.class})
@Import(value={ZipkinSQSCredentialsConfiguration.class})
@AutoConfigureAfter(name={"zipkin2.server.internal.ZipkinServerConfiguration"})
class ZipkinSQSCollectorModule {
    @Autowired(required=false)
    AwsClientBuilder.EndpointConfiguration endpointConfiguration;

    ZipkinSQSCollectorModule() {
    }

    @Bean
    SQSCollector sqsCollector(ZipkinSQSCollectorProperties properties, AWSCredentialsProvider credentialsProvider, CollectorSampler sampler, CollectorMetrics metrics, StorageComponent storage) {
        return properties.toBuilder().queueUrl(properties.getQueueUrl()).waitTimeSeconds(properties.getWaitTimeSeconds()).parallelism(properties.getParallelism()).endpointConfiguration(this.endpointConfiguration).credentialsProvider(credentialsProvider).sampler(sampler).metrics(metrics).storage(storage).build().start();
    }

    static final class SQSSetCondition
    extends SpringBootCondition {
        private static final String PROPERTY_NAME = "zipkin.collector.sqs.queue-url";

        SQSSetCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String queueUrl = context.getEnvironment().getProperty(PROPERTY_NAME);
            return SQSSetCondition.isEmpty(queueUrl) ? ConditionOutcome.noMatch((String)"zipkin.collector.sqs.queue-url isn't set") : ConditionOutcome.match();
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }
    }
}

