/*
 * Decompiled with CFR 0.152.
 */
package zipkin.module.aws.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.module.aws.kinesis.ZipkinKinesisCollectorModule;
import zipkin.module.aws.kinesis.ZipkinKinesisCollectorProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinKinesisCollectorProperties.class})
@Conditional(value={ZipkinKinesisCollectorModule.KinesisSetCondition.class})
class ZipkinKinesisCredentialsConfiguration {
    @Autowired(required=false)
    private AWSSecurityTokenService securityTokenService;

    ZipkinKinesisCredentialsConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={STSSetCondition.class})
    AWSSecurityTokenService securityTokenService(ZipkinKinesisCollectorProperties properties) {
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(ZipkinKinesisCredentialsConfiguration.getDefaultCredentialsProvider(properties))).withRegion(properties.getAwsStsRegion())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    AWSCredentialsProvider credentialsProvider(ZipkinKinesisCollectorProperties properties) {
        if (this.securityTokenService != null) {
            return new STSAssumeRoleSessionCredentialsProvider.Builder(properties.getAwsStsRoleArn(), "zipkin-server").withStsClient(this.securityTokenService).build();
        }
        return ZipkinKinesisCredentialsConfiguration.getDefaultCredentialsProvider(properties);
    }

    private static AWSCredentialsProvider getDefaultCredentialsProvider(ZipkinKinesisCollectorProperties properties) {
        DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
        if (ZipkinKinesisCredentialsConfiguration.notNullOrEmpty(properties.getAwsAccessKeyId()) && ZipkinKinesisCredentialsConfiguration.notNullOrEmpty(properties.getAwsSecretAccessKey())) {
            provider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.getAwsAccessKeyId(), properties.getAwsSecretAccessKey()));
        }
        return provider;
    }

    private static boolean notNullOrEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static final class STSSetCondition
    extends SpringBootCondition {
        private static final String PROPERTY_NAME = "zipkin.collector.kinesis.aws-sts-role-arn";

        STSSetCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String stsRoleArn = context.getEnvironment().getProperty(PROPERTY_NAME);
            return STSSetCondition.isEmpty(stsRoleArn) ? ConditionOutcome.noMatch((String)"zipkin.collector.kinesis.aws-sts-role-arn isn't set") : ConditionOutcome.match();
        }

        private static boolean isEmpty(String s) {
            return s == null || s.isEmpty();
        }
    }
}

