/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.operator.handler;

import io.yupiik.bundlebee.core.cli.Args;
import io.yupiik.bundlebee.core.command.Executable;
import io.yupiik.bundlebee.core.command.impl.ApplyCommand;
import io.yupiik.bundlebee.core.command.impl.DeleteCommand;
import io.yupiik.bundlebee.operator.configuration.ThreadLocalConfigSource;
import io.yupiik.bundlebee.operator.model.Event;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Provider;

@ApplicationScoped
public class ActionHandler {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @Inject
    private Provider<DeleteCommand> deleteCommandProvider;
    @Inject
    private Provider<ApplyCommand> applyCommandProvider;
    @Inject
    private ThreadLocalConfigSource threadLocalConfigSource;

    public void onEvent(String type, Event.AlveoliObject obj) {
        switch (type.toUpperCase(Locale.ROOT)) {
            case "DELETED": {
                this.logger.info(() -> "[D] Deleting '" + obj.getMetadata().getName() + "'");
                this.execute("delete", this.deleteCommandProvider, obj);
                break;
            }
            case "ADDED": {
                this.logger.info(() -> "[A] Applying '" + obj.getMetadata().getName() + "'");
                this.execute("apply", this.applyCommandProvider, obj);
                break;
            }
            case "MODIFIED": {
                this.logger.info(() -> "[U] Updating '" + obj.getMetadata().getName() + "'");
                this.execute("apply", this.applyCommandProvider, obj);
                break;
            }
            default: {
                this.logger.warning("[E] Unknown event: type=" + type);
            }
        }
    }

    private void execute(String cmd, Provider<? extends Executable> provider, Event.AlveoliObject obj) {
        this.threadLocalConfigSource.forConfiguration(this.toConf(cmd, obj), () -> {
            try {
                return ((Executable)provider.get()).execute().toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                this.logger.log(Level.SEVERE, e, e::getMessage);
                throw new IllegalStateException(e);
            }
        });
    }

    private Map<String, String> toConf(String cmd, Event.AlveoliObject obj) {
        return obj.getSpec() == null || obj.getSpec().getArgs() == null || obj.getSpec().getArgs().isEmpty() ? Map.of() : Args.toProperties((String)cmd, (String[])((String[])Stream.concat(Stream.of(cmd), obj.getSpec().getArgs().stream()).toArray(String[]::new)));
    }
}

