/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.operator;

import io.yupiik.bundlebee.core.configuration.ConfigurableConfigSource;
import io.yupiik.bundlebee.operator.launcher.OperatorLoop;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.eclipse.microprofile.config.Config;

public final class BundlebeeOperator {
    private BundlebeeOperator() {
    }

    public static void main(String ... args) {
        Map<String, String> config = IntStream.rangeClosed(0, args.length / 2 - 1).boxed().collect(Collectors.toMap(idx -> {
            String value = args[1 + idx * 2];
            return value.startsWith("--") ? value.substring("--".length()) : value;
        }, idx -> args[(1 + idx) * 2]));
        Logger logger = Logger.getLogger(BundlebeeOperator.class.getName());
        try (SeContainer container = SeContainerInitializer.newInstance().initialize();){
            BundlebeeOperator.injectArgsInMPConfig(config, container);
            ((OperatorLoop)container.select(OperatorLoop.class, new Annotation[0]).get()).run(new AtomicBoolean(true));
            logger.info("Stopping Bundlebee Operator");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e, e::getMessage);
            throw new IllegalStateException(e);
        }
    }

    private static void injectArgsInMPConfig(Map<String, String> config, SeContainer container) {
        StreamSupport.stream(((Config)container.select(Config.class, new Annotation[0]).get()).getConfigSources().spliterator(), false).filter(ConfigurableConfigSource.class::isInstance).map(ConfigurableConfigSource.class::cast).findFirst().orElseThrow().getProperties().putAll(config);
    }
}

