/*
 * Decompiled with CFR 0.152.
 */
package io.whitesource.cure;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class SecureObjectInputStream
extends ObjectInputStream {
    private final Set<String> classesWhitelist;
    private final Set<String> packagesWhitelist = new HashSet<String>();

    public SecureObjectInputStream(InputStream inputStream, Set<String> validClassNames) throws IOException {
        super(inputStream);
        this.classesWhitelist = validClassNames;
    }

    public SecureObjectInputStream(InputStream inputStream, Set<String> validClassNames, Set<String> validPackages) throws IOException {
        super(inputStream);
        this.classesWhitelist = validClassNames;
        this.packagesWhitelist.addAll(validPackages);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classToDeserialize) throws IOException, ClassNotFoundException {
        String className = classToDeserialize.getName();
        if (this.classesWhitelist.contains(className) || this.isSubpackage(className)) {
            return super.resolveClass(classToDeserialize);
        }
        throw new InvalidClassException("Unauthorized deserialization attempt detected for class " + classToDeserialize.getName());
    }

    private boolean isSubpackage(String className) {
        String packageName = FilenameUtils.removeExtension((String)className);
        for (String pack : this.packagesWhitelist) {
            if (!packageName.startsWith(pack)) continue;
            return true;
        }
        return false;
    }
}

