/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.caconfig.editor.impl;

import io.wcm.caconfig.editor.DropdownOptionItem;
import io.wcm.caconfig.editor.DropdownOptionProvider;
import io.wcm.caconfig.editor.impl.JsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={DropdownOptionProviderService.class})
public class DropdownOptionProviderService {
    private BundleContext bundleContext;

    @Activate
    private void activated(BundleContext bc) {
        this.bundleContext = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Map<String, Object>> getDropdownOptions(@NotNull String selector, @NotNull Resource contextResource) {
        block5: {
            List<Map<String, Object>> list;
            String filter = "(io.wcm.caconfig.editor.widget.dropdown.provider=" + selector + ")";
            ServiceReference ref = this.bundleContext.getServiceReferences(DropdownOptionProvider.class, filter).stream().findFirst().orElse(null);
            if (ref == null) break block5;
            DropdownOptionProvider provider = (DropdownOptionProvider)this.bundleContext.getService(ref);
            try {
                list = this.toMapList(provider.getDropdownOptions(contextResource));
            }
            catch (Throwable throwable) {
                try {
                    this.bundleContext.ungetService(ref);
                    throw throwable;
                }
                catch (InvalidSyntaxException ex) {
                    throw new RuntimeException("Invalid filter syntax: " + filter, ex);
                }
            }
            this.bundleContext.ungetService(ref);
            return list;
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<Map<String, Object>> toMapList(@NotNull List<DropdownOptionItem> items) {
        return items.stream().map(item -> {
            Map map = (Map)JsonMapper.OBJECT_MAPPER.convertValue(item, Map.class);
            return map;
        }).collect(Collectors.toList());
    }
}

