/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.LoggerFormat;
import io.vertx.ext.web.handler.LoggerFormatter;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.impl.Utils;

public class LoggerHandlerImpl
implements LoggerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerHandler.class);
    private final boolean immediate;
    private final LoggerFormat format;
    private LoggerFormatter logFormatter;

    public LoggerHandlerImpl(boolean immediate, LoggerFormat format) {
        this.immediate = immediate;
        this.format = format;
    }

    public LoggerHandlerImpl(LoggerFormat format) {
        this(false, format);
    }

    private String getClientAddress(SocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.host();
    }

    private void log(RoutingContext context, long timestamp, String remoteClient, HttpVersion version, HttpMethod method, String uri) {
        HttpServerRequest request = context.request();
        long contentLength = 0L;
        if (this.immediate) {
            String obj = request.headers().get("content-length");
            if (obj != null) {
                try {
                    contentLength = Long.parseLong(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            contentLength = request.response().bytesWritten();
        }
        String versionFormatted = "-";
        switch (version) {
            case HTTP_1_0: {
                versionFormatted = "HTTP/1.0";
                break;
            }
            case HTTP_1_1: {
                versionFormatted = "HTTP/1.1";
                break;
            }
            case HTTP_2: {
                versionFormatted = "HTTP/2.0";
            }
        }
        MultiMap headers = request.headers();
        int status = request.response().getStatusCode();
        String message = null;
        String referrer = null;
        String userAgent = null;
        switch (this.format) {
            case DEFAULT: {
                referrer = headers.contains("referrer") ? headers.get("referrer") : headers.get("referer");
                userAgent = request.headers().get("user-agent");
                referrer = referrer == null ? "-" : referrer;
                userAgent = userAgent == null ? "-" : userAgent;
                message = String.format("%s - - [%s] \"%s %s %s\" %d %d \"%s\" \"%s\"", remoteClient, Utils.formatRFC1123DateTime(timestamp), method, uri, versionFormatted, status, contentLength, referrer, userAgent);
                break;
            }
            case COMBINED: {
                referrer = headers.contains("referrer") ? headers.get("referrer") : headers.get("referer");
                userAgent = request.headers().get("user-agent");
                referrer = referrer == null ? "-" : referrer;
                userAgent = userAgent == null ? "-" : userAgent;
                User user = context.user();
                Object userId = "-";
                if (user != null && user.subject() != null && ((String)(userId = user.subject())).indexOf(32) != -1) {
                    userId = "\"" + (String)userId + "\"";
                }
                message = String.format("%s - %s [%s] \"%s %s %s\" %d %d \"%s\" \"%s\"", remoteClient, userId, Utils.formatStrftimeDateTime(timestamp), method, uri, versionFormatted, status, contentLength, referrer, userAgent);
                break;
            }
            case SHORT: {
                message = String.format("%s - %s %s %s %d %d - %d ms", remoteClient, method, uri, versionFormatted, status, contentLength, System.currentTimeMillis() - timestamp);
                break;
            }
            case TINY: {
                message = String.format("%s %s %d %d - %d ms", method, uri, status, contentLength, System.currentTimeMillis() - timestamp);
                break;
            }
            case CUSTOM: {
                try {
                    message = this.logFormatter.format(context, System.currentTimeMillis() - timestamp);
                    break;
                }
                catch (RuntimeException e) {
                    message = e.getMessage();
                }
            }
        }
        this.doLog(status, message);
    }

    protected void doLog(int status, String message) {
        if (status >= 500) {
            LOG.error((Object)message);
        } else if (status >= 400) {
            LOG.warn((Object)message);
        } else {
            LOG.info((Object)message);
        }
    }

    public void handle(RoutingContext context) {
        long timestamp = System.currentTimeMillis();
        String remoteClient = this.getClientAddress(context.request().remoteAddress());
        HttpMethod method = context.request().method();
        String uri = context.request().uri();
        HttpVersion version = context.request().version();
        if (this.immediate) {
            this.log(context, timestamp, remoteClient, version, method, uri);
        } else {
            context.addEndHandler((Handler<AsyncResult<Void>>)((Handler)v -> this.log(context, timestamp, remoteClient, version, method, uri)));
        }
        context.next();
    }

    @Override
    public LoggerHandler customFormatter(LoggerFormatter formatter) {
        if (this.format != LoggerFormat.CUSTOM) {
            throw new IllegalStateException("Setting a formatter requires the handler to be set to CUSTOM format");
        }
        this.logFormatter = formatter;
        return this;
    }
}

