/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.util.internal.StringUtil;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htdigest.HtdigestCredentials;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigestAuthHandlerImpl
extends HTTPAuthorizationHandler<HtdigestAuth>
implements DigestAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPAuthorizationHandler.class);
    private static final String DEFAULT_NONCE_MAP_NAME = "htdigest.nonces";
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final Pattern SPLITTER = Pattern.compile(",(?=(?:[^\"]|\"[^\"]*\")*$)");
    private static final MessageDigest MD5;
    private final VertxContextPRNG random;
    private final LocalMap<String, Nonce> nonces;
    private final long nonceExpireTimeout;
    private long lastExpireRun;

    public DigestAuthHandlerImpl(Vertx vertx, HtdigestAuth authProvider, long nonceExpireTimeout) {
        super(authProvider, HTTPAuthorizationHandler.Type.DIGEST, authProvider.realm());
        this.random = VertxContextPRNG.current((Vertx)vertx);
        this.nonces = vertx.sharedData().getLocalMap(DEFAULT_NONCE_MAP_NAME);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public Future<User> authenticate(RoutingContext context) {
        long now = System.currentTimeMillis();
        if (now - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            HashSet toRemove = new HashSet();
            this.nonces.forEach((key, n) -> {
                if (n != null && n.createdAt + this.nonceExpireTimeout < now) {
                    toRemove.add(key);
                }
            });
            for (String n2 : toRemove) {
                this.nonces.remove((Object)n2);
            }
            this.lastExpireRun = now;
        }
        return this.parseAuthorization(context).compose(header -> {
            String opaque;
            HtdigestCredentials credentials = new HtdigestCredentials();
            try {
                String[] tokens = SPLITTER.split((CharSequence)header);
                int len = tokens.length;
                block28: for (int i = 0; i < len; ++i) {
                    Matcher m = PARSER.matcher(tokens[i]);
                    if (!m.find()) continue;
                    switch (m.group(1)) {
                        case "algorithm": {
                            credentials.setAlgorithm(m.group(2));
                            continue block28;
                        }
                        case "cnonce": {
                            credentials.setCnonce(m.group(2));
                            continue block28;
                        }
                        case "method": {
                            credentials.setMethod(m.group(2));
                            continue block28;
                        }
                        case "nc": {
                            credentials.setNc(m.group(2));
                            continue block28;
                        }
                        case "nonce": {
                            credentials.setNonce(m.group(2));
                            continue block28;
                        }
                        case "opaque": {
                            credentials.setOpaque(m.group(2));
                            continue block28;
                        }
                        case "qop": {
                            credentials.setQop(m.group(2));
                            continue block28;
                        }
                        case "realm": {
                            credentials.setRealm(m.group(2));
                            continue block28;
                        }
                        case "response": {
                            credentials.setResponse(m.group(2));
                            continue block28;
                        }
                        case "uri": {
                            credentials.setUri(m.group(2));
                            continue block28;
                        }
                        case "username": {
                            credentials.setUsername(m.group(2));
                            continue block28;
                        }
                        default: {
                            LOG.info((Object)("Uknown parameter: " + m.group(1)));
                        }
                    }
                }
                String nonce = credentials.getNonce();
                if (!this.nonces.containsKey((Object)nonce)) {
                    return Future.failedFuture((Throwable)UNAUTHORIZED);
                }
                if (credentials.getQop() != null) {
                    int nc = Integer.parseInt(credentials.getNc(), 16);
                    Nonce n = (Nonce)this.nonces.get((Object)nonce);
                    if (nc <= n.count) {
                        return Future.failedFuture((Throwable)UNAUTHORIZED);
                    }
                    this.nonces.put((Object)nonce, (Object)new Nonce(n.createdAt, nc));
                }
            }
            catch (RuntimeException e) {
                return Future.failedFuture((Throwable)e);
            }
            Session session = context.session();
            if (session != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(credentials.getOpaque())) {
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
            credentials.setMethod(context.request().method().name());
            SecurityAudit audit = ((RoutingContextInternal)context).securityAudit();
            audit.credentials((Credentials)credentials);
            return ((HtdigestAuth)this.authProvider).authenticate((Credentials)credentials).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> Future.failedFuture((Throwable)new HttpException(401, (Throwable)err)));
        });
    }

    @Override
    public boolean setAuthenticateHeader(RoutingContext context) {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        String nonce = DigestAuthHandlerImpl.md5(bytes);
        this.nonces.put((Object)nonce, (Object)new Nonce(0));
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes);
            opaque = DigestAuthHandlerImpl.md5(bytes);
        }
        context.response().headers().add("WWW-Authenticate", "Digest realm=\"" + this.realm + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"");
        return true;
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return StringUtil.toHexStringPadded((byte[])MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Nonce
    implements Shareable {
        private final long createdAt;
        private final int count;

        Nonce(int count) {
            this(System.currentTimeMillis(), count);
        }

        Nonce(long createdAt, int count) {
            this.createdAt = createdAt;
            this.count = count;
        }
    }
}

