/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import java.util.UUID;

public abstract class SockJSSocketBase
implements SockJSSocket {
    private final MessageConsumer<Buffer> registration;
    protected final Vertx vertx;
    protected RoutingContext routingContext;
    private final String writeHandlerID;

    @Override
    public abstract SockJSSocket exceptionHandler(Handler<Throwable> var1);

    protected SockJSSocketBase(Vertx vertx, RoutingContext rc, SockJSHandlerOptions options) {
        this.vertx = vertx;
        this.routingContext = rc;
        if (options.isRegisterWriteHandler()) {
            Handler writeHandler = msg -> this.write((Buffer)msg.body());
            this.writeHandlerID = UUID.randomUUID().toString();
            MessageConsumer consumer = options.isLocalWriteHandler() ? vertx.eventBus().localConsumer(this.writeHandlerID) : vertx.eventBus().consumer(this.writeHandlerID);
            this.registration = consumer.handler(writeHandler);
        } else {
            this.writeHandlerID = null;
            this.registration = null;
        }
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public Future<Void> end() {
        Promise promise = Promise.promise();
        if (this.registration != null) {
            this.registration.unregister((Handler)promise);
        } else {
            promise.complete();
        }
        return promise.future();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        if (this.registration != null) {
            this.registration.unregister(handler);
        } else {
            handler.handle((Object)Future.succeededFuture());
        }
    }

    @Override
    public void close() {
        this.end();
    }

    public void closeAfterSessionExpired() {
        this.close();
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingContext;
    }

    @Override
    public Session webSession() {
        return this.routingContext.session();
    }

    @Override
    public User webUser() {
        return this.routingContext.user();
    }
}

