/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.SessionStore;

public class SessionHandlerImpl
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName;
    private long sessionTimeout;
    private boolean nagHttps;
    private boolean sessionCookieSecure;
    private boolean sessionCookieHttpOnly;

    public SessionHandlerImpl(String sessionCookieName, long sessionTimeout, boolean nagHttps, boolean sessionCookieSecure, boolean sessionCookieHttpOnly, SessionStore sessionStore) {
        this.sessionCookieName = sessionCookieName;
        this.sessionTimeout = sessionTimeout;
        this.nagHttps = nagHttps;
        this.sessionStore = sessionStore;
        this.sessionCookieSecure = sessionCookieSecure;
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    public void handle(RoutingContext context) {
        Cookie cookie;
        String uri;
        context.response().ended();
        if (this.nagHttps && !(uri = context.request().absoluteURI()).startsWith("https:")) {
            log.warn((Object)("Using session cookies without https could make you susceptible to session hijacking: " + uri));
        }
        if ((cookie = context.getCookie(this.sessionCookieName)) != null) {
            String sessionID = cookie.getValue();
            this.getSession(context.vertx(), sessionID, (Handler<AsyncResult<Session>>)((Handler)res -> {
                if (res.succeeded()) {
                    Session session = (Session)res.result();
                    if (session != null) {
                        context.setSession(session);
                        session.setAccessed();
                        this.addStoreSessionHandler(context);
                    } else {
                        this.createNewSession(context);
                    }
                } else {
                    context.fail(res.cause());
                }
                context.next();
            }));
        } else {
            this.createNewSession(context);
            context.next();
        }
    }

    private void getSession(Vertx vertx, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.doGetSession(vertx, System.currentTimeMillis(), sessionID, resultHandler);
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID, (Handler<AsyncResult<Session>>)((Handler)res -> {
            long retryTimeout;
            if (res.succeeded() && res.result() == null && (retryTimeout = this.sessionStore.retryTimeout()) > 0L && System.currentTimeMillis() - startTime < retryTimeout) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle(res);
        }));
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler((Handler<Void>)((Handler)v -> {
            Session session = context.session();
            if (!session.isDestroyed()) {
                int currentStatusCode = context.response().getStatusCode();
                if (currentStatusCode >= 200 && currentStatusCode < 400) {
                    session.setAccessed();
                    this.sessionStore.put(session, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
                        if (res.failed()) {
                            log.error((Object)"Failed to store session", res.cause());
                        }
                    }));
                } else {
                    context.removeCookie(this.sessionCookieName);
                }
            } else {
                this.sessionStore.delete(session.id(), (Handler<AsyncResult<Boolean>>)((Handler)res -> {
                    if (res.failed()) {
                        log.error((Object)"Failed to delete session", res.cause());
                    }
                }));
            }
        }));
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout);
        context.setSession(session);
        Cookie cookie = Cookie.cookie(this.sessionCookieName, session.id());
        cookie.setPath("/");
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        context.addCookie(cookie);
        this.addStoreSessionHandler(context);
    }
}

