/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Locale;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import io.vertx.ext.web.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RoutingContextImpl
extends RoutingContextImplBase {
    private final RouterImpl router;
    private Map<String, Object> data;
    private AtomicInteger handlerSeq = new AtomicInteger();
    private Map<Integer, Handler<Void>> headersEndHandlers;
    private Map<Integer, Handler<Void>> bodyEndHandlers;
    private Throwable failure;
    private int statusCode = -1;
    private String normalisedPath;
    private String acceptableContentType;
    private Map<String, Cookie> cookies;
    private Buffer body;
    private Set<FileUpload> fileUploads;
    private Session session;
    private User user;
    private static final String DEFAULT_404 = "<html><body><h1>Resource not found</h1></body></html>";

    public RoutingContextImpl(String mountPoint, RouterImpl router, HttpServerRequest request, Set<RouteImpl> routes) {
        super(mountPoint, request, routes);
        this.router = router;
        if (request.path().charAt(0) != '/') {
            this.fail(404);
        }
    }

    @Override
    public HttpServerRequest request() {
        return this.request;
    }

    @Override
    public HttpServerResponse response() {
        return this.request.response();
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public boolean failed() {
        return this.failure != null || this.statusCode != -1;
    }

    @Override
    public void next() {
        if (!this.iterateNext()) {
            this.checkHandleNoMatch();
        }
    }

    private void checkHandleNoMatch() {
        if (this.failed()) {
            this.unhandledFailure(this.statusCode, this.failure, this.router);
        } else {
            this.response().setStatusCode(404);
            if (this.request().method() == HttpMethod.HEAD) {
                this.response().end();
            } else {
                this.response().end(DEFAULT_404);
            }
        }
    }

    @Override
    public void fail(int statusCode) {
        this.statusCode = statusCode;
        this.doFail();
    }

    @Override
    public void fail(Throwable t) {
        this.failure = t == null ? new NullPointerException() : t;
        this.doFail();
    }

    @Override
    public RoutingContext put(String key, Object obj) {
        this.getData().put(key, obj);
        return this;
    }

    @Override
    public Vertx vertx() {
        return this.router.vertx();
    }

    @Override
    public <T> T get(String key) {
        Object obj = this.getData().get(key);
        return (T)obj;
    }

    @Override
    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public String normalisedPath() {
        if (this.normalisedPath == null) {
            this.normalisedPath = Utils.normalisePath(this.request.path());
        }
        return this.normalisedPath;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.cookiesMap().get(name);
    }

    @Override
    public RoutingContext addCookie(Cookie cookie) {
        this.cookiesMap().put(cookie.getName(), cookie);
        return this;
    }

    @Override
    public Cookie removeCookie(String name) {
        return this.cookiesMap().remove(name);
    }

    @Override
    public int cookieCount() {
        return this.cookiesMap().size();
    }

    @Override
    public Set<Cookie> cookies() {
        return new HashSet<Cookie>(this.cookiesMap().values());
    }

    @Override
    public String getBodyAsString() {
        return this.body != null ? this.body.toString() : null;
    }

    @Override
    public String getBodyAsString(String encoding) {
        return this.body != null ? this.body.toString(encoding) : null;
    }

    @Override
    public JsonObject getBodyAsJson() {
        return this.body != null ? new JsonObject(this.body.toString()) : null;
    }

    @Override
    public JsonArray getBodyAsJsonArray() {
        return this.body != null ? new JsonArray(this.body.toString()) : null;
    }

    @Override
    public Buffer getBody() {
        return this.body;
    }

    @Override
    public void setBody(Buffer body) {
        this.body = body;
    }

    @Override
    public Set<FileUpload> fileUploads() {
        return this.getFileUploads();
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void clearUser() {
        this.user = null;
    }

    @Override
    public String getAcceptableContentType() {
        return this.acceptableContentType;
    }

    @Override
    public void setAcceptableContentType(String contentType) {
        this.acceptableContentType = contentType;
    }

    @Override
    public int addHeadersEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getHeadersEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeHeadersEndHandler(int handlerID) {
        return this.getHeadersEndHandlers().remove(handlerID) != null;
    }

    @Override
    public int addBodyEndHandler(Handler<Void> handler) {
        int seq = this.nextHandlerSeq();
        this.getBodyEndHandlers().put(seq, handler);
        return seq;
    }

    @Override
    public boolean removeBodyEndHandler(int handlerID) {
        return this.getBodyEndHandlers().remove(handlerID) != null;
    }

    @Override
    public void reroute(HttpMethod method, String path) {
        ((HttpServerRequestWrapper)this.request).setMethod(method);
        ((HttpServerRequestWrapper)this.request).setPath(path);
        this.normalisedPath = null;
        this.restart();
    }

    @Override
    public List<Locale> acceptableLocales() {
        String languages = this.request.getHeader("Accept-Language");
        if (languages != null) {
            List<String> acceptLanguages = Utils.getSortedAcceptableMimeTypes(languages);
            ArrayList<Locale> locales = new ArrayList<Locale>(acceptLanguages.size());
            for (String lang : acceptLanguages) {
                int idx = lang.indexOf(59);
                if (idx != -1) {
                    lang = lang.substring(0, idx).trim();
                }
                String[] parts = lang.split("_|-");
                switch (parts.length) {
                    case 3: {
                        locales.add(Locale.create(parts[0], parts[1], parts[2]));
                        break;
                    }
                    case 2: {
                        locales.add(Locale.create(parts[0], parts[1]));
                        break;
                    }
                    case 1: {
                        locales.add(Locale.create(parts[0]));
                    }
                }
            }
            return locales;
        }
        return Collections.emptyList();
    }

    private Map<Integer, Handler<Void>> getHeadersEndHandlers() {
        if (this.headersEndHandlers == null) {
            this.headersEndHandlers = new LinkedHashMap<Integer, Handler<Void>>();
            this.response().headersEndHandler(v -> this.headersEndHandlers.values().forEach(handler -> handler.handle(null)));
        }
        return this.headersEndHandlers;
    }

    private Map<Integer, Handler<Void>> getBodyEndHandlers() {
        if (this.bodyEndHandlers == null) {
            this.bodyEndHandlers = new LinkedHashMap<Integer, Handler<Void>>();
            this.response().bodyEndHandler(v -> this.bodyEndHandlers.values().forEach(handler -> handler.handle(null)));
        }
        return this.bodyEndHandlers;
    }

    private Map<String, Cookie> cookiesMap() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        return this.cookies;
    }

    private Set<FileUpload> getFileUploads() {
        if (this.fileUploads == null) {
            this.fileUploads = new HashSet<FileUpload>();
        }
        return this.fileUploads;
    }

    private void doFail() {
        this.iter = this.router.iterator();
        this.next();
    }

    private Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    private int nextHandlerSeq() {
        int seq = this.handlerSeq.incrementAndGet();
        if (seq == Integer.MAX_VALUE) {
            throw new IllegalStateException("Too many header/body end handlers!");
        }
        return seq;
    }
}

